<?php
/**
 * Шаблон для отображения ленты записей в сайдбаре.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

$query_arg['post_type'] = 'post';
$query_arg['posts_per_page'] = $instance['posts_number'];
switch ($instance['order_by']) {
	case 'none' : break;
	case 'id_asc' : $query_arg['orderby'] = 'ID'; $query_arg['order'] = 'ASC'; break;
	case 'id_desc' : $query_arg['orderby'] = 'ID'; $query_arg['order'] = 'DESC'; break;
	case 'date_asc' : $query_arg['orderby'] = 'date'; $query_arg['order'] = 'ASC'; break;
	case 'date_desc' : $query_arg['orderby'] = 'date'; $query_arg['order'] = 'DESC'; break;
	case 'title_asc' : $query_arg['orderby'] = 'title'; $query_arg['order'] = 'ASC'; break;
	case 'title_desc' : $query_arg['orderby'] = 'title'; $query_arg['order'] = 'DESC'; break;
	default : $query_arg['orderby'] = $instance['order_by'];
}
switch ($instance['filter']) {
	case 'cats' : $query_arg['cat='] = trim($instance['filter_cats']) ; break;
	case 'category' : $query_arg['cat='] = trim($instance['selected_category']) ; break;
	case 'tags' : $query_arg['tag='] = trim($instance['filter_tags']) ; break;
	default : $query_arg[''] = '';
}
global $post;
$query_arg['post__not_in'] = [ $post->ID ];
?>
					<div class="posts-widget">

						<?php if( $title ) { ?>

						<h3 class="widget-title"><?php echo $title; ?></h3>
						<?php } ?>

						<?php
						$posts = get_posts( $query_arg );
						foreach ( $posts as $post ) : setup_postdata( $post ); ?>

						<div class="posts-widget-item clearfix">

							<?php if ($instance['display_featured_image'] && has_post_thumbnail( $post->ID ) ) {
								$attachment_id = get_post_thumbnail_id( $post->ID );
								$image_attributes = wp_get_attachment_image_src( $attachment_id, 'preview' );
							?>

							<div class="posts-widget-thumbnail" style="width:<?php echo $instance['featured_image_size']; ?>px; height:<?php echo $instance['featured_image_size']; ?>px; float:<?php echo $instance['featured_image_align']; ?>;">
								<a href="<?php echo get_permalink( $post->ID ); ?>" title="<?php echo $post->post_title; ?>">
									<img class="img-responsive" src="<?php echo $image_attributes[0]; ?>" alt="<?php echo $post->post_title; ?>">
								</a>
							</div>
							<?php } ?>


							<?php if ( $instance['display_title'] ) { ?>
							<h4 class="posts-widget-title">
								<a href="<?php echo get_permalink($post->ID); ?>" rel="bookmark" title="<?php echo $post->post_title; ?>">
									<?php echo $post->post_title; ?>
								</a>
							</h4>
							<?php } ?>

							<?php if($instance['display_date'] || $instance['display_author']) { ?>
							<div class="posts-widget-meta">
								<?php 
								if($instance['display_date'] ) { ?>
									<span class="meta-date">
										<i class="fa fa-calendar fa-fw" aria-hidden="true"></i>&nbsp;
										<?php echo date( 'd.m.Y', strtotime($post->post_date) ); ?>
									</span>
								<?php
								}
								if($instance['display_time'] ) { ?>
									<span class="meta-time">
										<i class="fa fa-clock-o fa-fw" aria-hidden="true"></i>&nbsp;
										<?php echo date( 'G:i', strtotime($post->post_date) ); ?>
									</span>
								<?php
								}
								if($instance['display_author']) { ?>
									<span class="meta-author">
										<i class="fa fa-user fa-fw" aria-hidden="true"></i>&nbsp;
										<?php 
										$user_info = get_userdata( $post->post_author );
										$user_data = $user_info->data;
										if( isset($user_data->display_name) && $user_data->display_name != '' ) {
											$author = $user_data->display_name;
										} else {
											$author = $user_data->user_login;
										}
										echo ' ' . $author; ?>
									</span>
								<?php
								}
								?>

							</div>
							<?php } ?>
							<?php if( $instance['display_content'] || $instance['display_read_more'] ) {?>

							<div class="clearfix"></div>
							<div class="posts-widget-entry">
								<?php 
								if($instance['display_content'] ) {
									$excerpt_length = $instance['excerpt_length'] ? $instance['excerpt_length'] : 16;
									if( $instance['content_type'] == 'the_content' || $post->post_excerpt == '' ) {
										echo $this->shorten( $post->post_content, $excerpt_length );
									} else {
										echo $this->shorten( $post->post_excerpt, $excerpt_length );
									}
								}

								if($instance['display_read_more']) { ?>

								<a class="posts-widget-more" href="<?php the_permalink() ?>" rel="bookmark" title="<?php echo $post->post_title; ?>">
									&nbsp;<?php _e( 'More', 'spiral' ); ?> &raquo;
								</a>
								<?php 
								}
								?>

							</div>
							<?php } ?>

						</div>
					<?php endforeach; 
					wp_reset_postdata();?>
					</div>