<?php
/**
 * Амин часть виджета для отображения ленты записей в сайдбаре.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

?>
					<p>
						<label for="<?php echo $this->get_field_id('title'); ?>">Заголовок:</label>
						<br>
						<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
					</p>
					<p>
						<label for="<?php echo $this->get_field_id('posts_number'); ?>">Количество записей:</label>
						<br>
						<input class="widefat" id="<?php echo $this->get_field_id('posts_number'); ?>" name="<?php echo $this->get_field_name('posts_number'); ?>" type="text" value="<?php echo esc_attr($instance['posts_number']); ?>" />
					</p>
					<p>
						<label for="<?php echo $this->get_field_id('order_by'); ?>">Сортировка:</label>
						<br>
						<select id="<?php echo $this->get_field_id('order_by'); ?>" name="<?php echo $this->get_field_name('order_by'); ?>">
							<option value="none" <?php selected('none', $instance['order_by']); ?> >Без ( по умолчанию )</option>
							<option value="id_asc" <?php selected('id_asc', $instance['order_by']); ?> >ID ( Возрастание ) </option>
							<option value="id_desc" <?php selected('id_desc', $instance['order_by']); ?> >ID ( Убывание ) </option>
							<option value="date_asc"  <?php selected('date_asc', $instance['order_by']); ?>>Дата ( Возрастание ) </option>
							<option value="date_desc"  <?php selected('date_desc', $instance['order_by']); ?>>Дата ( Убывание ) </option>
							<option value="title_asc" <?php selected('title_asc', $instance['order_by']); ?>>Заголовок ( Возрастание ) </option>
							<option value="title_desc" <?php selected('title_desc', $instance['order_by']); ?>>Заголовок ( Убывание  ) </option>
							<option value="rand" <?php selected('rand', $instance['order_by']); ?>>Случайный порядок</option>
						</select>
					</p>
					<p>
						<span>Показывать элементы:</span>
						<br>

						<label for="<?php echo $this->get_field_id('display_title'); ?>">
							<input id="<?php echo $this->get_field_id('display_title'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_title'); ?>"  <?php checked( $instance['display_title']); ?> value="1" />
							<span>Заголовок статьи</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('display_date'); ?>">
							<input id="<?php echo $this->get_field_id('display_date'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_date'); ?>"  <?php checked( $instance['display_date']); ?> value="1" />
							<span>Дата</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('display_time'); ?>">
							<input id="<?php echo $this->get_field_id('display_time'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_time'); ?>"  <?php checked( $instance['display_time']); ?> value="1" />
							<span>Время</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('display_author'); ?>">
							<input id="<?php echo $this->get_field_id('display_author'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_author'); ?>"  <?php checked( $instance['display_author']); ?> value="1" />
							<span>Автор</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('display_content'); ?>">
							<input id="<?php echo $this->get_field_id('display_content'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_content'); ?>"  <?php checked( $instance['display_content']); ?> value="1" />
							<span>Текст / Цитата</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('display_featured_image'); ?>">
							<input id="<?php echo $this->get_field_id('display_featured_image'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_featured_image'); ?>"  <?php checked( $instance['display_featured_image']); ?> value="1" />
							<span>Миниатюра</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('display_read_more'); ?>">
							<input id="<?php echo $this->get_field_id('display_read_more'); ?>" type="checkbox" name="<?php echo $this->get_field_name('display_read_more'); ?>"  <?php checked( $instance['display_read_more']); ?> value="1" />
							<span>Ссылка "Подробнее"</span>
						</label>
					</p>
					<p>
						<span>Тип контента:</span>
						<br>

						<label>
							<input type="radio" name="<?php echo $this->get_field_name('content_type'); ?>" <?php checked('the_content', $instance['content_type']); ?> value="the_content" />
							<span>Статья</span>
						</label>
						<br>

						<label>
							<input type="radio" name="<?php echo $this->get_field_name('content_type'); ?>" <?php checked('the_excerpt', $instance['content_type']); ?> value="the_excerpt" />
							<span>Цитата</span>
						</label>
						<br>

						<label for="<?php echo $this->get_field_id('excerpt_length'); ?>">Длинна цитаты (слов):</label>
						<input style="width: 40px;" id="<?php echo $this->get_field_id('excerpt_length'); ?>" name="<?php echo $this->get_field_name('excerpt_length'); ?>" type="text" value="<?php echo esc_attr($instance['excerpt_length']); ?>" />
					</p>
					<p>
						<span>Миниатюра:</span>
						<br>

						<span>Размер:</span>
						<input type="text" style="width: 40px;" name="<?php echo $this->get_field_name('featured_image_size'); ?>" value="<?php echo esc_attr($instance['featured_image_size']); ?>" />
						&nbsp; 
						<span>Ориентация:</span>
						<select name="<?php echo $this->get_field_name('featured_image_align'); ?>">
							<option value="left" <?php selected('left', $instance['featured_image_align']); ?> >С лева</option>
							<option value="right"  <?php selected('right', $instance['featured_image_align']); ?>>С права</option>
							<option value="center" <?php selected('center', $instance['featured_image_align']); ?>>По центру</option>
						</select>
					</p>
					<p>
						<span>Фильтр:</span>
						<br>

						<input type="radio" name="<?php echo $this->get_field_name('filter'); ?>" <?php checked('recent', $instance['filter']); ?> value="recent" />
						<span>Последние записи</span>
						<br>

						<input type="radio" name="<?php echo $this->get_field_name('filter'); ?>" <?php checked('category', $instance['filter']); ?> value="category" />
						<span>Записи из рубрики:</span>
						<br>
						<select name="<?php echo $this->get_field_name('selected_category'); ?>">
						<?php
							$categories = get_categories('hide_empty=0');
							foreach ($categories as $category) {
								$category_selected = $this->get_field_name('selected_category') == $category->cat_ID ? ' selected="selected" ' : '';
								?>
								<option value="<?php echo $category->cat_ID; ?>" <?php selected($category->cat_ID, $instance['selected_category']); ?> ><?php echo $category->cat_name; ?></option>
								<?php
							}
						?>
						</select>
						<br>

						<input type="radio" name="<?php echo $this->get_field_name('filter'); ?>" <?php checked('cats', $instance['filter']); ?> value="cats" />
						<label for="<?php echo $this->get_field_id('filter_cats'); ?>">
							Записи из выбранных рубрик:
						</label>
						<br>
						<span>ID рубрик ( Пример: 5,9,24 )</span>
						<br>
						<input class="widefat" id="<?php echo $this->get_field_id('filter_cats'); ?>" name="<?php echo $this->get_field_name('filter_cats'); ?>" type="text" value="<?php echo esc_attr($instance['filter_cats']); ?>" />
						<br>

						<input type="radio" name="<?php echo $this->get_field_name('filter'); ?>" <?php checked('tags', $instance['filter']); ?> value="tags" />
						<label for="<?php echo $this->get_field_id('filter_tags'); ?>">
							Записи помеченные тегами:
						</label>
						<br>
						<span>Ярлыки тегов ( computer,news,business )</span>
						<br>
						<input class="widefat" id="<?php echo $this->get_field_id('filter_tags'); ?>" name="<?php echo $this->get_field_name('filter_tags'); ?>" type="text" value="<?php echo esc_attr($instance['filter_tags']); ?>" />		
					</p>