<?php
/**
 * Поиск категорий
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

// Укорачивание
function excerpt($txt,$limit) {
	$txt = explode(' ', $txt, $limit);
	if (count($txt)>=$limit) {
		array_pop($txt);
		$txt = implode(" ",$txt).'...';
	} else {
		$txt = implode(" ",$txt);
	}	
	$txt = preg_replace('`[[^]]*]`','',$txt);
	return $txt;
}

function tax_name($tax) {
	$tax = str_replace('_',' ',$tax);
	$tax = str_replace('-',' ',$tax);
	$first = mb_substr($tax,0,1, 'UTF-8');//первая буква
	$last = mb_substr($tax,1);//все кроме первой буквы
	$first = mb_strtoupper($first, 'UTF-8');
	$last = mb_strtolower($last, 'UTF-8');
	return __($first.$last,'spiral');
}



					$tax = get_taxonomies();
					$tax = array_diff($tax, ['nav_menu'=>'nav_menu','link_category'=>'link_category','post_format'=>'post_format']);
					$terms = get_terms([
						'taxonomy' => $tax,
						'name__like' => $s,
						'hide_empty' => false // Optional
					]);

					if ( count($terms) > 0 ){
					?>

						<article class="feed-serch clearfix" itemprop="itemListElement" itemscope itemtype="http://schema.org/BlogPosting">
					<?php
						foreach ( $terms as $term ) {
					?>
							<div class="col-sm-3">
								<h2 itemprop="name" class="text-left"><?php echo tax_name($term->taxonomy); ?>:</h2>
							</div>
							<div class="col-sm-9">
								<h2 itemprop="name" class="text-left"><a href="<?php echo esc_url( get_term_link( $term ) ); ?>" rel="bookmark" title="<?php echo esc_attr( $term->name ); ?>"><?php echo esc_html( $term->name ); ?></a></h2>
							</div>
							<div class="col-sm-12">
								<?php echo excerpt($term->description,50); ?>
							</div>
					<?php
						}
					?>
						</article><!-- #post-<?php the_ID(); ?>-->
						<div class="clearfix"></div>
					<?php
					}