<?php
/**
 * Верхнее меню лендинга.
 * 
 * Для анимации id="navbar-landing" и убрать class="navbar-fixed-top"
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

require_once TEMPLATEPATH . '/view/navbar/_fix_type.php';
?>
			<div class="fixed-nav-wrapper">
				<!-- Static navbar -->
				<nav id="navbar-landing-fixed" class="navbar <?php echo $navbar; ?> navbar-fixed-top" itemscope itemtype="http://schema.org/SiteNavigationElement">
					<div class="container">
						<div class="navbar-header">
							<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#scroll-spy-menu" aria-expanded="true" aria-controls="scroll-spy-menu">
								<i class="fa fa-bars" aria-hidden="true"></i>
							</button>

							<?php
								// Разметка кнопки вызова списка телефонов
								get_template_part('view/navbar/_btn_phones_xs'); 
							?>

							<?php
								// Разметка логотипа
								get_template_part('view/navbar/_logo'); 
							?>

						</div>
						<div id="scroll-spy-menu" class="navbar-collapse collapse">

						<?php
							// Иконки соцсетей
							if( has_action( 'social_networks_nav' ) ) {
								do_action( 'social_networks_nav' );
							}
							// Контактный телефон
							if( has_action( 'one_phone_nav' ) ) {
								do_action( 'one_phone_nav' );
							}
						?>

						<?php
							$args = array(
								'theme_location'	=>	'top-bar-landing',
								'depth'				=>	3,
								'container'			=>	false,
								'echo'				=>	true, // Для внедрения логотипа поменять - результат копируется в переменную
								'menu_class'		=>	'nav navbar-nav navbar-right',
								'fallback_cb'		=>	'Bootstrap_Walker_Nav_Menu::fallback',
								'walker'			=>	new Bootstrap_Walker_Nav_Menu()
							);
							wp_nav_menu($args);
						?>
						</div><!--/.navbar-collapse -->
					</div><!-- /.container -->
				</nav><!-- /#navbar-landing-fixed -->
			</div><!-- /.fixed-nav-wrapper -->
