<?php
/**
 * Выбор селекторов для верхнего меню.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

	// Выбор загружаемого меню
	if( is_page_template('page-template-home.php') ) {
		$veselka_navbar = get_option('var_navbar');
	} elseif( is_page_template('landing.php') ) {
		$veselka_navbar = get_option('var_navbar_landing');
	} else {
		$veselka_navbar = get_option('var_navbar_inner');
	}

	$navbar = 'navbar-inverse';
	$type = explode('-', $veselka_navbar);
	if( in_array( end($type), ['default','inverse']) ) {
		$navbar = 'navbar-' . end($type);
	}
	$fixed = '';
	if( (is_front_page() && get_option('var_navbar_fixed_top')) ||
		(!is_front_page() && get_option('var_navbar_inner_fixed_top'))
	) {
		$fixed = ' navbar-fixed-top';
	}
	$class = 'navbar ' . $navbar . $fixed;
?>