<?php
/**
 * Шапка сайта с телефонами.
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

?>

		<header id="masthead-navbar-contacts" class="container affix-add" itemscope itemtype="http://schema.org/WPHeader">
			<div class="masthead clearfix">
				<div class="row">
					<div id="site-title" class="col-md-4 col-sm-4">
						<span><?php bloginfo('name'); ?></span>
						<?php get_template_part( 'view/header/_meta_headline' ); ?>
					</div>
					<?php
					$veselka_phone = get_option('phone_number');
					if( $veselka_phone ) {
						$phone_sanitized = (string)str_replace(['+38','-','_','(',')',' '], '', $veselka_phone);
						$phone_sanitized = '(' .
										substr($phone_sanitized, 0, 3) .
										') ' .
										substr($phone_sanitized, 3, 3) .
										'-' .
										substr($phone_sanitized, 6, 2) .
										'-' .
										substr($phone_sanitized, 8, 2);
					?>

					<div class="head-phone col-md-4 col-sm-4">
						<a href="tel:<?php echo $veselka_phone; ?>" title="<?php bloginfo('name'); ?> - <?php echo __('Contact phone number', 'spiral' ); ?>">
							<span class="glyphicon glyphicon-phone-alt"></span>&nbsp;
							<?php echo $phone_sanitized; ?>
						</a>
					</div>
					<?php
					}
					
					$veselka_phone = get_option('phone_number2');
					if( $veselka_phone ) {
						$phone_sanitized = str_replace('+38', '', $veselka_phone);
						$phone_sanitized = str_replace(' ', '', $phone_sanitized);
						$phone_sanitized = '(' .
										substr($phone_sanitized, 0, 3) .
										') ' .
										substr($phone_sanitized, 3, 3) .
										'-' .
										substr($phone_sanitized, 6, 2) .
										'-' .
										substr($phone_sanitized, 8, 2);
					?>

					<div class="head-phone col-md-4 col-sm-4">
						<a href="tel:<?php echo $veselka_phone; ?>" title="<?php bloginfo('name'); ?> - <?php echo __('Contact phone number', 'spiral' ); ?>">
							<span class="glyphicon glyphicon-phone-alt"></span>&nbsp;
							<?php echo $phone_sanitized; ?>
						</a>
					</div>
					<?php
					}

					$veselka_email = get_option('public_email');
					if( !$veselka_email ) {
						$veselka_email = get_option('admin_email');
					}
					if( $veselka_email ) {
					?>

					<div class="head-email col-md-4 col-sm-4">
						<a href="mailto:<?php echo $veselka_email; ?>" title="<?php bloginfo('name'); ?> - <?php echo __('Write a letter', 'spiral' ); ?>">
							<span class="glyphicon glyphicon-envelope"></span>&nbsp;
							<?php echo $veselka_email; ?>
						</a>
					</div>
					<?php
					}
					?>

				</div><!-- /.row -->
			</div><!-- /#masthead -->
		</header><!-- /.container -->

<?php get_template_part( 'view/navbar/_select_top' ); ?>