<?php
/**
 * Вариант с большим количеством телефонов.
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

?>
	<footer id="footer" class="affix-sub" itemscope itemtype="http://schema.org/WPFooter">

	<?php
		// Подключение меню футера
		get_template_part('view/footer/_select_menu'); 
	?>

		<div id="footer-content" itemscope itemtype="http://schema.org/Organization">
			<div class="container">
				<div class="row">

					<div class="col-sm-6 col-sm-push-6 col-md-3 col-md-push-0">
						<div id="sprite">
						<?php
							if( file_exists( TEMPLATEPATH . 'assets/img/sprite/logo-footer.php' ) ) {
								if( !is_home() && !is_front_page() ) {
						?>
							<a id="sprite-logo" class="sprite-img" href="<?php echo get_home_url(); ?>" title="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>"><span></span></a>
						<?php
								} else {
						?>
							<span id="sprite-logo" class="sprite-img"><span></span></span>
						<?php
								}
							}
						?>
						</div><!-- /#sprite -->
					</div>

					<div class="col-sm-6 col-sm-pull-6 col-md-3 col-md-pull-0">
						<div id="footer-nav">

						<?php
							if( has_action( 'all_phones_list' ) ) {
								do_action( 'all_phones_list' );
							}
						?>
						</div><!-- /#footer-nav -->
					</div>

					<div class="clearfix visible-sm-block"></div>

					<div class="col-sm-6 col-md-3">
						<div id="footer-contacts">

						<?php
							if( has_action( 'microdata_email' ) ) {
								do_action( 'microdata_email' );
							}
						?>

						<?php
							if( has_action( 'microdata_address' ) ) {
								do_action( 'microdata_address' );
							}
						?>

						</div><!-- /#contacts -->
					</div>

					<div class="col-sm-6 col-md-3 offer-add-info">
						<div id="veselka">

							<?php
							$page_slug ='footer-part';
							$page_data = get_page_by_path($page_slug);
							if( $page_data ) {
							?>
							<div class="text-gray-dark">
								<?php echo apply_filters('the_content', $page_data->post_content); ?>
							</div>
							<?php
							}
							?>

							<a id="veselka-logo" class="sprite-img" href="http://veselka.ua" title="Создание и продвижение сайта" target="_blank"><span></span></a>

						</div><!-- /#veselka -->
					</div>

				</div><!-- /.row -->
			</div><!-- /.container -->
		</div><!-- /#footer-content -->

		<?php get_template_part('view/footer/_footer_footer'); ?>

	</footer><!-- #site-footer -->