<?php
/**
 * Template Name: Contacts with map
 * Template Post Type: page
 *
 * Шаблон для отображения страниц с контактной формой, картой проезда, контактными данными.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

get_header();

?>

				<div id="content" class="col-md-12 scroll-section">
				<?php 
					do_action( 'content_before' );

					if( have_posts() )
					{
						// Цикл Вордпресс
						while( have_posts() ) : the_post();
					?>

					<article id="<?php echo $post->post_name ?>" <?php post_class("clearfix"); ?> itemscope itemtype="https://schema.org/Organization">

						<header class="entry-meta">
						<?php get_template_part('view/post/title'); ?>
						</header><!-- .entry-meta -->

						<div itemprop="articleBody" class="entry-content">
							<div class="row">

								<div class="col-sm-12">
									<?php the_content(); ?>
								</div>

								<div class="clearfix visible-sm-block visible-xs-block"></div>

								<div class="col-sm-6 col-md-4">
									<div id="contacts-nav">
									<?php
									if( (bool)get_option('public_contacts_sort') ) {
										if( has_action( 'get_sorted_phones' ) ) {
											do_action( 'get_sorted_phones' );
										}
									} else {
										if( has_action( 'all_phones_list' ) ) {
											do_action( 'all_phones_list' );
										}
									}
									?>
									</div><!-- /#contacts-nav -->
								</div>

								<div class="col-sm-6 col-md-4">
									<div id="page-contacts">

									<?php
									if( (bool)get_option('public_contacts_sort') ) {
										if( has_action( 'microdata_full_address' ) ) {
											do_action( 'microdata_full_address' );
										}
										if( has_action( 'microdata_one_email' ) ) {
											do_action( 'microdata_one_email' );
										}
										if( has_action( 'social_networks_contacts' ) ) {
											do_action( 'social_networks_contacts' );
										}
									} else {
										if( has_action( 'microdata_full_email' ) ) {
											do_action( 'microdata_full_email' );
										}
										if( has_action( 'microdata_full_address' ) ) {
											do_action( 'microdata_full_address' );
										}
									}
									?>

									</div><!-- /#page-contacts -->
								</div>

									<?php if( has_action( 'get_static_contact_form' ) ) { ?>

									<div class="col-sm-12 col-md-4">

										<?php do_action( 'get_static_contact_form', 'static_contact' ); ?>

									</div>

									<?php } ?>
		
							</div><!-- .row -->
						</div><!-- .entry-content -->

					</article>

					<?php
						endwhile;
					}

					do_action( 'content_after' );
					?>

				</div><!-- #content -->


			</div><!-- /.row -->
		</div><!-- /.container -->
<?php
// Карта
if( has_action( 'organization_map_data' ) ) {
	do_action( 'organization_map_data' );
} // endif
?>

<?php
	get_footer();
?>
