<?php
/**
 * Template Name: Map with multiple markers
 * Template Post Type: page
 *
 * Шаблон для отображения страниц с картой проезда, контактными данными.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

get_header();

?>

				<div id="content" class="col-md-12 scroll-section">
				<?php 
					do_action( 'content_before' );

					if( have_posts() )
					{
						// Цикл Вордпресс
						while( have_posts() ) : the_post();
					?>

					<article id="<?php echo $post->post_name ?>" <?php post_class("clearfix"); ?> itemscope itemtype="https://schema.org/Organization">

						<header class="entry-meta">
						<?php get_template_part('view/post/title'); ?>
						</header><!-- .entry-meta -->

						<div itemprop="articleBody" class="entry-content">
							<div class="row">

								<div class="col-sm-12">
									<?php the_content(); ?>
								</div>

								<?php
								// Карта
								if( has_action( 'multiple_contacts_data' ) ) {
									do_action( 'multiple_contacts_data' );
								} // endif
								?>

							</div><!-- .row -->
						</div><!-- .entry-content -->

					</article>

					<?php
						endwhile;
					}

					do_action( 'content_after' );
					?>

				</div><!-- #content -->


			</div><!-- /.row -->
		</div><!-- /.container -->

<?php
// Карта
if( has_action( 'multiple_contacts_map_data' ) ) {
	do_action( 'multiple_contacts_map_data' );
} // endif
?>

<?php
	get_footer();
?>
