<?php
/**
 * Подмена шаблонов.
 *
 * Подменяет шаблоны для произвольных типов постов.
 * Подменяет шаблоны для произвольных таксономий.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class WpThemeRedirect {


	use PluginsPath;

	/**
	 * Список реципиентов
	 * @type array
	 */
	private $recipients = [];


	public function __construct() {

		// Проверка наличия плагина
		// Плагины могут быть дочерними (частными случаями)
		// Имена констрант с путями могут совпадать для разных имен плагинов
		$this->check_plugins();

		/*
		 * Передача текущего объекта в фильтр по ссылке для объктов использующих общие методы
		 */
		foreach( $this->plugins_tax as $recipient => $plugin ) {
			if( has_action( $recipient.'_template_redirect' ) ) {
				do_action_ref_array( $recipient.'_template_redirect', [&$this] );
			}
		}
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Роутер.
	 *
	 * @param atring $post_type
	 * @return void
	 */
	final public function redirect_router($post_type) {

		global $wp_query;
		// Указанный тип записи
		if( $wp_query->query_vars['post_type'] == $post_type ) {
			$this->search_post_template_file($post_type);
		// Указанная таксономия
		} elseif( isset($wp_query->query_vars['taxonomy']) && isset($this->plugins_tax[$wp_query->query_vars['taxonomy']]) ) {
			$this->search_tax_template_file($post_type, $wp_query->query_vars['taxonomy']);
		}
	}


//////////////////// Приватные и защищенные методы ////////////////////


	/**
	 * Поиск шаблона произвольной записи.
	 *
	 * @param string $post_type
	 * @return void
	 */
	private function search_post_template_file($post_type) {
		// Имя плагина
		$plugin = $this->plugins_posts[$post_type];
		// Путь к шаблону
		$template = $this->plugins_path[$plugin] . '/view/' . $post_type . '.php' ;
		if( file_exists($template) ) {
			global $post, $wp_query;
			if( have_posts() ) {
				include($template);
				die();
			} else {
				$wp_query->is_404 = true;
			}
		}
	}


	/**
	 * Поиск шаблона таксономии.
	 *
	 * @param string $post_type
	 * @return void
	 */
	private function search_tax_template_file($post_type, $tax_name) {
		// Имя плагина
		$plugin = $this->plugins_posts[$post_type];
		// Путь к шаблону
		$template = $this->plugins_path[$plugin] . '/view/' . $tax_name . '.php' ;
		if( file_exists($template) ) {
			include($template);
			die();
		}
	}


} //end WpThemeRedirect