<?php
/**
 * Конструирование wp_head()
 *
 * Добавляет нижеупомянутые блоки тегов.
 *
 * Загрузка CSS стилей.
 * Загрузка иконок для устройств, favicon.
 * Загрузка SEO метатегов.
 *
 *
 * @author veselka.ua
 * @version 0.4
 *
 * @package veselka_ua/themes
 */

class WpThemeHead {



	public function __construct() {

		// Вывод элементов в хедере
		add_action( 'wp_head', [$this, 'get_head_elements'], 20 );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Обертка для крючка в хедере (hook) вордпресс.
	 *
	 * @param void
	 * @return void
	 */
	public function get_head_elements() {
		$this->head_construct();
	}


//////////////////// Приватные методы ////////////////////


	/**
	 * Постоение HTML кода <head>.
	 *
	 * @param void
	 * @return string|bool
	 */
	private function head_construct() {
    	// RSS Feed
    	if( (bool)get_option('head_rss') ) {
			echo PHP_EOL . "\t" . '<!-- RSS -->';
            echo PHP_EOL . "\t" . '<link rel="alternate" type="application/rss+xml" title="' . get_bloginfo('name') . ' RSS Feed" href="' . $this->options['meta_rss'] . '" />' . PHP_EOL;
        }
	}

} //end WpThemeHead
?>