<?php
/**
 * Уборака мусора wp_head()
 *
 * Убирает неиспользуемые <link>'s
 * Убирает лишние CSS элементы галереи и виджетов.
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

class WpCleanup {


	public function __construct() {
		$this->load();
	}

	/**
	 * Инициализация.
	 * Первоначальная развертывание.
	 *
	 * @param void
	 * @return void
	 */
	private function load() {

		// Проблема с автоабзацами
		remove_filter( 'the_content', 'wpautop' );
		remove_filter('term_description','wpautop');
		add_filter( 'the_content', 'wpautop' , 99);
		add_filter( 'the_content', [$this, 'remove_empty_p'] ,100 );
		

		// Очискка ссылки цитаты
		if( (bool)get_option('head_cleanup_exerpts') ) {
			add_filter( 'excerpt_more', create_function( '', 'return "";' ) );
		}
		/**
		 * Убирает WordPress версию из заголовка и RSS ленты
		 */
		if( (bool)get_option('head_cleanup_wp_version') ) {
			remove_action( 'wp_head','wp_generator' );
			add_filter('the_generator', '__return_false');
		}
		if( (bool)get_option('head_cleanup_rsd_link') ) {
			remove_action( 'wp_head', 'rsd_link' );
		}
		if( (bool)get_option('head_cleanup_wlwmanifest_link') ) {
			remove_action( 'wp_head', 'wlwmanifest_link' );
		}
		if( (bool)get_option('head_cleanup_adjacent_posts_link') ) {
			remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head' );
		}
		if( (bool)get_option('head_cleanup_rel_canonical') ) {
			remove_action('wp_head', 'rel_canonical');
		}
		if( (bool)get_option('head_cleanup_feed_links_extra') ) {
			remove_action( 'wp_head', 'feed_links_extra', 3 );
			remove_action( 'wp_head', 'feed_links', 2 );
		}
		if( (bool)get_option('head_cleanup_wp_shortlink_wp_head') ) {
			remove_action( 'wp_head', 'wp_shortlink_wp_head' );
		}
		if( (bool)get_option('head_cleanup_wp_emojicons') ) {
			remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
			remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
			remove_action( 'wp_print_styles', 'print_emoji_styles' );
			remove_action( 'admin_print_styles', 'print_emoji_styles' );
			add_filter( 'emoji_svg_url', '__return_false' );
		}
		if( (bool)get_option('head_cleanup_rest_api') ) {
			// Отключаем сам REST API
			add_filter('rest_enabled', '__return_false');
			// Отключаем фильтры REST API
			remove_action( 'xmlrpc_rsd_apis',				'rest_output_rsd' );
			remove_action( 'wp_head',						'rest_output_link_wp_head', 10, 0 );
			remove_action( 'wp_head',						'wp_oembed_add_discovery_links' );
			remove_action( 'wp_head', 						'wp_oembed_add_host_js' );
			remove_action( 'template_redirect',				'rest_output_link_header', 11, 0 );
			remove_action( 'auth_cookie_malformed',			'rest_cookie_collect_status' );
			remove_action( 'auth_cookie_expired',			'rest_cookie_collect_status' );
			remove_action( 'auth_cookie_bad_username',		'rest_cookie_collect_status' );
			remove_action( 'auth_cookie_bad_hash',			'rest_cookie_collect_status' );
			remove_action( 'auth_cookie_valid',				'rest_cookie_collect_status' );
			remove_filter( 'rest_authentication_errors',	'rest_cookie_check_errors', 100 );
			// Отключаем события REST API
			remove_action( 'init',							'rest_api_init' );
			remove_action( 'rest_api_init',					'rest_api_default_filters', 10, 1 );
			remove_action( 'parse_request',					'rest_api_loaded' );
			// Отключаем Embeds связанные с REST API
			remove_action( 'rest_api_init',					'wp_oembed_register_route' );
			remove_filter( 'rest_pre_serve_request',		'_oembed_rest_pre_serve_request', 10, 4 );
		}
	}


	/**
	 * Удаление пустых абзацев.
	 *
	 * @param string $content
	 * @return string $content
	 */
	final public function remove_empty_p($content) {
		// Parse nested shortcodes and add formatting
		$content = trim( do_shortcode( shortcode_unautop( $content ) ) );
		// Remove any instances of ''
		$content = str_replace( '<p></p>', '', $content );
		$content = str_replace( '<p>  </p>', '', $content );
		
		return $content;
	}


} //end WpCleanup
?>