<?php
/**
 * Работа с пользовательскими таксономиями.
 * TODO: запилить в шаблоне перманентно
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

trait CustomTaxPostClass {

	/**
	 * Добавляет селекторы в обертку товаров.
	 *
	 * Добавляет имена пользовательских таксономий.
	 * Метод используется в крючке вордпресс.
	 *
	 * @param array $classes
	 * @param string $class
	 * @param string $ID
	 */
	final public function add_custom_taxonomy_post_class( $classes, $class, $ID ) {

		// Получение всех пользовательских таксономий
		$taxonomies_args = array(
			'public' => true,
			'_builtin' => false,
		);
		$taxonomies = get_taxonomies( $taxonomies_args, 'names', 'and' );

		// Получение объектов таксономий по заданным именам и текущему ID поста
		$terms = get_the_terms( (int)$ID, (array)$taxonomies );

		// Запись уникальных значений имен таксономий в массив с селекторами
		if( !empty( $terms ) ) {
			foreach( (array) $terms as $order => $term ) {
				if( !in_array( $term->slug, $classes ) ) {
					$classes[] = $term->slug;
				}
			}
		}

		return $classes;
	}

} // end CustomTaxPostClass
?>