<?php
/**
 * Формирует необходимый заголовок сайта.
 *
 * Изменяет wp_title() в зависимости от ситуации.
 *
 *
 *
 * @param object $semantic_kernel
 *
 * @author veselka.ua
 * @version 2.0
 *
 * @package veselka_ua/themes
 */

class SeoTitle {

	/**
	 * Объект семантического ядра.
	 * @type object
	 */
	private $semantic_kernel;
	/**
	 * Свойство для формирования результата.
	 * @type array
	 */
	private $seo_data = [];


	public function __construct( &$semantic_kernel = false ) {

		/**
		 * Объект семантического ядра.
		 */
		if( $semantic_kernel && is_object($semantic_kernel) ) {
			$this->semantic_kernel = $semantic_kernel;
		}

		// В крючке вызывается метод определенный в родительском объекте
		add_filter( 'wp_title', [$this, 'get_data' ], 1, 0 );
	}


	/**
	 * Обертка для получения результата работыобъекта.
	 * 
	 * Обращение происходит в крючке ворпресс.
	 * Крючек вордпресс должен находится в конструкторе объекта.
	 *
	 * @param void
	 * @return string
	 */
	final public function get_data() {
		echo $this->construct_seo_data();
	}


	/**
	 * Получение результата.
	 *
	 * @param void
	 * @return string
	 */
	private function construct_seo_data() {
		// Текущее состояние семантического ядра и сбор данных
		$this->semantic_kernel->load();
		// Подготовка объекта к работе
		$this->load();
		// Сбор прописанных данных
		$this->seo_collect();
		// Генерация недостающих данных
		$this->seo_generate();
		// HTML оформление SEO данных
		return $this->seo_formalization();
	}


	/**
	 * Подготовка объекта к работе.
	 *
	 * @param void
	 * @return void
	 */
	private function load() {
		$this->seo_data['title'] = NULL;
	}


	/**
	 * Поиск прописанных мета-тегов в дополнительных полях.
	 *
	 * @param void
	 * @return void
	 */
	private function seo_collect() {
		// Формирование имени метода в зависимости от состояния системы.
		$method_name = $this->semantic_kernel->registry['current_mode'] . '_meta_collect';
		// Вызов соответствующего метода для сбора прописанных метданнх.
		if( method_exists( $this, $method_name ) ) {
			$this->{$method_name}();
		}
	}


	/**
	 * Сбор данных произвольных полей страницы.
	 * -- Вспомогательный метод. --
	 *
	 * @param void
	 * @return void
	 */
	private function page_meta_collect() {
		// Поиск title в дополнительных полях записи.	
		$title = get_post_meta( $this->semantic_kernel->registry['id'], 'title', true );
		if( $title ) {
			$this->seo_data['title'] = $title;
		}
	}


	/**
	 * Сбор данных произвольных полей записи.
	 * -- Вспомогательный метод. --
	 *
	 * @param void
	 * @return void
	 */
	private function single_meta_collect() {
		$this->page_meta_collect();
	}


	/**
	 * Сбор данных произвольных полей записи.
	 * -- Вспомогательный метод. --
	 *
	 * @param void
	 * @return void
	 */
	private function home_meta_collect() {
		$this->page_meta_collect();
	}


	/**
	 * Сбор данных произвольных полей категории.
	 * -- Вспомогательный метод. --
	 *
	 * @param void
	 * @return void
	 */
	private function category_meta_collect() {

		// Мета данные
		$tax_data = get_term_meta( $this->semantic_kernel->registry['id'] );
		// Поиск соотвествующих метатегов в дополнительных полях категории.		
		if( $tax_data['cat_title'][0] ) {
			$this->seo_data['title'] = $tax_data['cat_title'][0];
		}

	}


	/**
	 * Сбор данных произвольных полей категорий недвижимости.
	 * -- Вспомогательный метод. --
	 *
	 * @param void
	 * @return void
	 */
	private function realty_meta_collect() {

		// Мета данные
		$tax_data = get_term_meta( $this->semantic_kernel->registry['id'] );
		// Поиск соотвествующих метатегов в дополнительных полях категории.		
		if( isset($tax_data['cat_title'][0]) ) {
			$this->seo_data['title'] = $tax_data['cat_title'][0];
		}

	}


	/**
	 * Сбор данных произвольных полей категорий товаров.
	 * -- Вспомогательный метод. --
	 *
	 * @param void
	 * @return void
	 */
	private function catalog_meta_collect() {

		// Мета данные
		$tax_data = get_term_meta( $this->semantic_kernel->registry['id'] );
		// Поиск соотвествующих метатегов в дополнительных полях категории.		
		if( isset($tax_data['cat_title'][0]) ) {
			$this->seo_data['title'] = $tax_data['cat_title'][0];
		}

	}


	/**
	 * Генерация SEO тегов.
	 *
	 * @param void
	 * @return void
	 */
	private function seo_generate() {
		if( $this->seo_data['title'] == NULL ) {

			// Генератор вынесен в общий объект
			$this->seo_data['title'] = $this->semantic_kernel->generator_load('metatitle');
		}
	}


	/**
	 * Формирование HTML кода мета-тегов.
	 *
	 * @param void
	 * @return void
	 */
	private function seo_formalization() {
		if( !$this->seo_data['title'] || $this->seo_data['title'] == '' ) {
			$this->seo_data['title'] = get_the_title();
		}
		//var_dump($this->registry);
		return $this->seo_data['title'];
	}

} //end SeoTitle
?>