<?php
/**
 *    H1 .
 *
 *
 *
 * @param object $semantic_kernel
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class SeoHeading {

	/**
	 *   .
	 * @type object
	 */
	private $semantic_kernel = false;
	/**
	 *    .
	 * @type string
	 */
	private $seo_h1 = [];


	public function __construct( &$semantic_kernel = false ) {

		/**
		 *   .
		 */
		if( $semantic_kernel && is_object($semantic_kernel) ) {
			$this->semantic_kernel = $semantic_kernel;
		}

		//       H1
		add_action( 'h1_title', [$this, 'get_data' ], 10, 0 );

		//       H1
		add_filter( 'get_h1_title', [$this, 'return_data' ], 1, 1 );
	}

	/**
	 *     .
	 * 
	 *     .
	 *       .
	 *
	 * @param void
	 * @return string
	 */
	final public function get_data() {
		$this->construct_seo_data();
		echo $this->seo_h1;
	}

	/**
	 *     .
	 * 
	 *     .
	 *       .
	 *
	 * @param void
	 * @return string
	 */
	final public function return_data($flag) {
		$this->construct_seo_data();
		return $this->seo_h1;
	}

	/**
	 *  .
	 *
	 * @param void
	 * @return string
	 */
	private function construct_seo_data() {
		//  
		if( isset($this->semantic_kernel->registry['h1']) && $this->semantic_kernel->registry['h1'] != '' ) {
			$this->seo_h1 = $this->semantic_kernel->registry['h1'];
		} else {
			$this->seo_h1 = get_the_title();
		}
		//var_dump($this->semantic_kernel);
	}


} //end SeoHeading
?>