<?php
/**
 * Подсчет количесва просмотров.
 * 
 * Запписывает количество просмотров в дополнительные поля записи.
 * 
 * 
 * @param object $lib_construct
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class RatingCounter {


	/**
	 * Массив параметров.
	 * @type array
	 */
	private $options;


	public function __construct() {
		// Крючек вордпресс
		add_action('wp_head', [$this, 'post_views_count'] );
	}


	/**
	 * Обертка для записи рейтинга.
	 *
	 * @param void
	 * @return void
	 */
	final public function post_views_count() {
		// Один раз за каждую загрузку
		if( $this->options['post_views'] ) {
			return true;
		}
		// Запись параметров
		$this->set_options();
		// Проверка исключений
		$this->check_exeptions();
		// Запись колчичества просмотров
		$this->set_views_count();
		//var_dump($this->options);
	}



	/**
	 * Запись параметров.
	 *
	 * @param void
	 * @return void
	 */
	private function set_options() {
		if(!empty($this->options)) {
			return true;
		}
		$this->options['post_views'] = false;
		$this->options['mode'] = false;
		$this->options['id'] = NULL;
		$this->options['meta_key'] = 'views_count';
		$this->options['exclude_users'] = false;
		$this->options['exclude_bots'] = true;
		$this->options['bots'] = [ 'bot', 'crawler' ];
		$this->options['bots_above'] = [ 'Yandex', 'slurp', 'yahoo', 'Teoma', 'Scooter', 'ia_archiver', 'Lycos', 'Rambler', 'Mail\.Ru', 'Aport', 'WebAlta', 'ezooms', 'nigma' ];
		$this->options['bots_beyond'] = [ 'jeeves', 'technorati', 'findexa', 'findlinks', 'gaisbo', 'zyborg', 'bloglines', 'blogsearch', 'pubsub', 'syndic8', 'userland', 'become\.com' ];
	}


	/**
	 * Проверка исключений.
	 *
	 * @param void
	 * @return bool
	 */
	private function check_exeptions() {
		// Не запись
		if( !is_singular('post') ) {
			return true;
		} else {
			$this->options['id'] = get_the_ID();
		}
		// Отсеивание зарегистрированных пользвоателей
		if( $this->options['exclude_users'] ) {
			$user_ID = get_current_user_id();
			if( $user_ID != 0 ) {
				return true;
			}
		}
		// Отсеивание ботов
		if( $this->options['exclude_bots'] ) {
			$useragent = $_SERVER['HTTP_USER_AGENT'];
			if( in_array( $useragent, $this->options['bots'] ) &&
				in_array( $useragent, $this->options['bots_above'] ) &&
				in_array( $useragent, $this->options['bots_beyond'] )
			) {
				return true;
			}
		}
		// Успешно
		$this->options['mode'] = true;
	}


	/**
	 * Запись колчичества просмотров.
	 *
	 * @param void
	 * @return void
	 */
	private function set_views_count() {
		// Проверки не прошли
		if( !$this->options['mode'] ) {
			return true;
		}
		// Количество загрузок
		$this->options['post_views'] = (int)get_post_meta( $this->options['id'], $this->options['meta_key'], true );
		// Обновление параметра
		if( !update_post_meta( $this->options['id'], $this->options['meta_key'], ($this->options['post_views']+1) ) ) {
			add_post_meta( $this->options['id'], $this->options['meta_key'], 1, true);
		}
	}

} // end RatingCounter