<?php
/**
 * Меню
 *
 * Регистрирует меню.
 * Очищает селекторы навигационных меню от рудиментов Вордпресс.
 * Добавляет необходимые селекторы для работы Bootstrap.
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

class NavMenu {

	public function __construct() {
		add_action( 'after_setup_theme', [ $this, 'get_bootstrap_menu_setup' ] );
		add_filter( 'nav_menu_css_class', [ $this, 'veselka_nav_menu_css_class' ], 10, 2 );
		add_filter( 'nav_menu_item_id', '__return_null');
		add_filter( 'wp_nav_menu_args', [ $this, 'veselka_nav_menu_args' ], 10, 1 );
	}

	/**
	 * Обертка для подключения меню.
	 *
	 * @param void
	 * @return void
	 */
	final public function get_bootstrap_menu_setup(){
		add_action( 'init', [ $this, 'register_pills_menu' ] );
		add_action( 'init', [ $this, 'register_navbar_menu' ] );
		add_action( 'init', [ $this, 'register_navbar_menu_second' ] );
		add_action( 'init', [ $this, 'register_navbar_menu_footer' ] );
		add_action( 'init', [ $this, 'register_navbar_menu_landing' ] );
	}

	/**
	 * Регистрирует меню в виде кнопок.
	 *
	 * @param void
	 * @return void
	 */
	final public function register_pills_menu(){
		register_nav_menu( 'top-bar-pills', 'Bootstrap Pills Menu' );
	}

	/**
	 * Регистрирует верхнее меню.
	 *
	 * @param void
	 * @return void
	 */
	final public function register_navbar_menu(){
		register_nav_menu( 'top-bar-nav', 'Bootstrap Header Navbar Menu' );
	}

	/**
	 * Регистрирует меню в подвале.
	 *
	 * @param void
	 * @return void
	 */
	final public function register_navbar_menu_second(){
		register_nav_menu( 'top-bar-nav-second', 'Bootstrap Navbar Menu Second' );
	}

	/**
	 * Регистрирует меню в подвале.
	 *
	 * @param void
	 * @return void
	 */
	final public function register_navbar_menu_footer(){
		register_nav_menu( 'bottom-bar-nav', 'Bootstrap Footer Navbar Menu' );
	}

	/**
	 * Регистрирует меню лендинга.
	 *
	 * @param void
	 * @return void
	 */
	final public function register_navbar_menu_landing(){
		register_nav_menu( 'top-bar-landing', 'Bootstrap Landing Menu' );
	}

	/**
	 * Убирает the id="" в элементах меню.
	 * Возвращает 'menu-slug' для селекторов навигационного меню.
	 *
	 * @param array $classes
	 * @param obj $item
	 * @return array
	 */
	final public function veselka_nav_menu_css_class($classes, $item) {
		$slug = sanitize_title($item->title);
		$classes = preg_replace('/(current(-menu-|[-_]page[-_])(item|parent|ancestor))/', 'active', $classes);
		$classes = preg_replace('/^((menu|page)[-_\w+]+)+/', '', $classes);

		$classes[] = 'menu-' . $slug;
		$classes = array_unique($classes);

		//return array_filter($classes, 'is_element_empty');
		$classes = array_filter($classes);
		return $classes;
	}

	/**
	 * Очищает wp_nav_menu_args
	 *
	 * Очищает контейнер.
	 * Использует по умолчанию Nav_Walker()
	 *
	 * @param array $args
	 * @return array
	 */
	final public function veselka_nav_menu_args($args = '') {

		$nav_menu_args['container'] = false;

		if( !$args['items_wrap'] ) {
			$nav_menu_args['items_wrap'] = '<ul class="%2$s">%3$s</ul>';
		}
		if( current_theme_supports('bootstrap-top-navbar') && !$args['depth'] ) {
			$nav_menu_args['depth'] = 2;
		}
		if( !$args['walker'] ) {
			$nav_menu_args['walker'] = new Bootstrap_Walker_Nav_Menu();
		}

		return array_merge($args, $nav_menu_args);
	}

} // end NavMenu
?>