<?php
/**
 * Галерея
 *
 *
 * 1. Правка разметки галереи под bootstrap
 * 2. Добавление class="thumbnail img-thumbnail" к медиафайлам
 * 3. Правка номеров стобцов ( -2 -3 -4 -5 -7 -8 -9 -10 ) для шорткода галереи
 *
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

class ImgGalleryHighslide {

	/**
	 * Объект обработки библиотек.
	 * @type object
	 */
	private $lib_kit;


	public function __construct() {


		if( !is_admin() ) {
			/**
			 * Хук для получение объекта с общими методами.
			 */
			add_action( 'wp_lib_construct_exchange', [$this, 'get_wp_lib_construct'], 28, 1 );

			// Библиотека owl.
			add_action( 'after_setup_theme', [$this, 'add_plain_highslide'] );
		}


		/**
		 * Правка разметки галереи
		 */
		remove_shortcode('gallery');
		add_shortcode('gallery',  array($this, 'wp_bootstrap_gallery'));
		/**
		 * Не использовать стиль для галереи по умолчанию
		 */
		add_filter('use_default_gallery_style', '__return_null');
		/**
		 * Галерея
		 */
		add_theme_support('bootstrap-gallery');
		/**
		 * Колонки нативной галереи
		 */
		add_action( 'wp_enqueue_media', array($this, 'media_gallery_additional_columns') );

	}


//////////////////// Публичные методы ////////////////////


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * Сортировка.
	 *
	 * @param object $lib_construct
	 * @return void
	 */
	final public function get_wp_lib_construct( $lib_construct ){
		// Объект с общими методами в локальное свойство
		$this->lib_kit = $lib_construct;
	}


	/**
	 * Добавить HighSlide.
	 *
	 * @param void
	 * @return void
	 */
	final public function add_plain_highslide() {

		/**
		 * Библиотека highslide.
		 */
		if( !(bool)get_option('gallery_plain_highslide') ) {
			// Ресайз изображений
			//$this->lib_kit->set_new_lib('highslide', ['page-template-contact.php', 'page-template-landing.php']);
		}
	}


	/**
	 * Правка разметки галереи под bootstrap.
	 *
	 * @param array $attr
	 * @return string $output
	 */
	final public function wp_bootstrap_gallery($attr) {
		$post = get_post();

		static $instance = 0;
		$instance++;

		if (!empty($attr['ids'])) {
			if (empty($attr['orderby'])) {
				$attr['orderby'] = 'post__in';
			}
			$attr['include'] = $attr['ids'];
		}

		$output = apply_filters('post_gallery', '', $attr);

		if ($output != '') {
			return $output;
		}

		if (isset($attr['orderby'])) {
			$attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
			if (!$attr['orderby']) {
				unset($attr['orderby']);
			}
		}

		extract(shortcode_atts(array(
			'order'			=> 'ASC',
			'orderby'		=> 'menu_order ID',
			'id'			=> $post->ID,
			'itemtag'		=> '',
			'icontag'		=> '',
			'captiontag'	=> '',
			'columns'		=> 3,
			'size'			=> 'thumbnail',
			'include'		=> '',
			'exclude'		=> '',
			'link'			=> 'file'
		), $attr));

		$id = intval($id);
		$columns = (12 % $columns == 0) ? $columns: 3;
		$grid = sprintf('col-sm-%1$s col-lg-%1$s', 12/$columns);
	
		if ($order === 'RAND') {
			$orderby = 'none';
		}

		if (!empty($include)) {
			$_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

			$attachments = array();
			foreach ($_attachments as $key => $val) {
				$attachments[$val->ID] = $_attachments[$key];
			}
		} elseif (!empty($exclude)) {
			$attachments = get_children(array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));
		} else {
			$attachments = get_children(array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));
		}

		if (empty($attachments)) {
			return '';
		}

		if (is_feed()) {
			$output = "\n";
			foreach ($attachments as $att_id => $attachment) {
				$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
			}
			return $output;
		}

		$unique = (get_query_var('page')) ? $instance . '-p' . get_query_var('page'): $instance;
		$output = '<div class="gallery gallery-' . $id . '-' . $unique . '">';

		$i = 0;
		foreach ($attachments as $id => $attachment) {
			switch($link) {
				case 'file':
					$image = wp_get_attachment_link($id, $size, false, false);
					break;
				case 'none':
					$image = wp_get_attachment_image($id, $size, false, array('class' => 'thumbnail img-thumbnail'));
					break;
				default:
					$image = wp_get_attachment_link($id, $size, true, false);
					break;
			}
			$output .= ($i % $columns == 0) ? '<div class="row gallery-row">': '';
			$output .= '<div class="' . $grid .'">' . $image;
	
			if (trim($attachment->post_excerpt)) {
				$output .= '<div class="highslide-caption">' . wptexturize($attachment->post_excerpt) . '</div>';
			}
	
			$output .= '</div>';
			$i++;
			$output .= ($i % $columns == 0) ? '</div>' : '';
		}
	
		$output .= ($i % $columns != 0 ) ? '</div>' : '';
		$output .= '</div>';
	
		return $output;
	}


	/**
	 * Колонки нативной галереи.
	 *
	 * @param void
	 * @return void
	 */
	final public function media_gallery_additional_columns(){
		add_action( 'admin_print_footer_scripts', array($this, 'media_gallery_additional_columns_script'), 999);
	}


	/**
	 * JS.
	 *
	 * @param void
	 * @return string
	 */
	final public function media_gallery_additional_columns_script(){
	?>
	<script type="text/javascript">
	jQuery(function(){
		if(wp.media.view.Settings.Gallery){
			wp.media.view.Settings.Gallery = wp.media.view.Settings.extend({
				className: "collection-settings gallery-settings",
				template: wp.media.template("gallery-settings"),
				render:	function() {
					wp.media.View.prototype.render.apply( this, arguments );
					// Append an option for 12 columns if not already present...
					var $s = this.$('select.columns');
					if(!$s.find('option[value="12"]').length){
						$s.append('<option value="12">12</option>');
					}
					$s.find('option[value="5"]').remove();
					$s.find('option[value="7"]').remove();
					$s.find('option[value="8"]').remove();
					$s.find('option[value="9"]').remove();
					// Select the correct values.
					_( this.model.attributes ).chain().keys().each( this.update, this );
					return this;
				}
			});
		}
	});
	</script>
	<?php
	}


} // end ImgGalleryHighslide
?>