<?php
/**
 * Адаптивность изображений
 *
 *
 * 1. Добавление селектора "img-responsive" к изображениям
 * 2. Добавление микроразметки itemprop="image"
 * 3. Дополнительные размеры миниатюр
 *
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

class ImgFix {

	/**
	 * Объект обработки библиотек.
	 * @type object
	 */
	private $lib_kit;


	public function __construct() {

		if( !is_admin() ) {

			/**
			 * Хук для получение объекта с общими методами.
			 */
			add_action( 'wp_lib_construct_exchange', [$this, 'get_wp_lib_construct'], 25, 1 );

			// Добавить HighSlide
			add_action( 'after_setup_theme', [$this, 'add_plain_highslide'] );
		}

		/**
		 * Дополнительные элементы для картинок
		 */
		if( (bool)get_option('gallery_plain') ) {
			add_filter( 'post_thumbnail_html', [$this, 'bootstrap_responsive_images'], 15, 1 );
			add_filter( 'the_content', [$this, 'bootstrap_responsive_images'], 25, 1 );
			add_filter( 'image_send_to_editor', [$this, 'bootstrap_responsive_images'], 20, 1);
		}

		/**
		 * Расширенный список размеров изображений в админпанели.
		 */
		//if( (bool)get_option('gallery_plain_thumbnails') ) {
			add_action( 'after_setup_theme', [$this, 'add_img_custom_sizes'] );
			add_filter( 'image_size_names_choose', [$this, 'img_custom_sizes'] );
		//}

		/**
		 * Ссылки медиафайлов.
		 */
		add_filter('wp_get_attachment_link', [$this, 'wp_attachment_link_class'], 10, 1);

	}


//////////////////// Публичные методы ////////////////////


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * Сортировка.
	 *
	 * @param object $lib_construct
	 * @return void
	 */
	final public function get_wp_lib_construct( $lib_construct ){
		// Объект с общими методами в локальное свойство
		$this->lib_kit = $lib_construct;
	}


	/**
	 * Добавить HighSlide.
	 *
	 * @param void
	 * @return void
	 */
	final public function add_plain_highslide() {

		/**
		 * Библиотека highslide.
		 */
		if( (bool)get_option('gallery_plain_highslide') ) {
			// Ресайз изображений
			$this->lib_kit->set_new_lib('highslide-full', ['page-template-contact.php', 'page-template-landing.php']);
			$this->lib_kit->set_new_lib('highslide', ['page-template-contact.php', 'page-template-landing.php']);

		}
	}


	/**
	 * Добавление селектора "img-responsive" к изображениям.
	 *
	 * @param string $html
	 * @return string $html
	 */
	final public function bootstrap_responsive_images( $html ){

		// Microdata
		$pattern = '!<img width="(.*?)" height="(.*?)" (.*?)/>!si';
		$replacement = '<span itemprop="image" itemscope itemtype="https://schema.org/ImageObject"><img itemprop="url" width="\\1" height="\\2" \\3/><meta itemprop="width" content="\\1"><meta itemprop="height" content="\\2"></span>';
		$html = preg_replace($pattern, $replacement, $html);	

		$classes = 'img-responsive'; // separated by spaces, e.g. 'img image-link'
		// check if there are already classes assigned to the anchor
		if ( preg_match('/<img.*? class="/', $html) ) {
			$html = preg_replace('/(<img.*? class=".*?)(".*?\/>)/', '$1 ' . $classes . ' $2', $html);
		} else {
			$html = preg_replace('/(<img.*?)(\/>)/', '$1 class="' . $classes . '" $2', $html);
		}
		// remove dimensions from images,, does not need it!
		$html = preg_replace( '/(width|height)=\"\d*\"\s/', "", $html );
		// Microdata
		//$pattern = '<img ';
		//$replacement = '<img itemprop="image" ';
		//$html = str_replace($pattern, $replacement, $html);


		// link
		/*$pattern = '<a';
		$replacement = '<a class="highslide-thumbnail"';
		$html = str_replace($pattern, $replacement, $html);
		// Microdata
		$pattern = '<a';
		$replacement = '<a itemprop="thumbnailUrl"';
		$html = str_replace($pattern, $replacement, $html);*/
		// Aligment
		$html = str_replace('alignleft', 'pull-left', $html);
		$html = str_replace('alignright', 'pull-right', $html);
		$html = str_replace('aligncenter', 'center-block', $html);

		return $html;
	}


	/**
	 * Дополнительные размеры миниатюр.
	 *
	 * @param array $sizes
	 * @return array
	 */
	final public function add_img_custom_sizes() {
		add_theme_support( 'post-thumbnails' );

		if( function_exists( 'add_image_size' ) ) {
			add_image_size( 'icons', 68, 68, true );
			add_image_size( 'preview', 150, 150, true );
			add_image_size( 'square', 370, 370, true );
			add_image_size( 'hd', 1920, 1920, false );
		}

	}


	/**
	 * Массив имен миниатюр в админпанели.
	 *
	 * @param array $sizes
	 * @return array
	 */
	final public function img_custom_sizes( $sizes ) {
		return array_merge( $sizes, [
				'icons'		=>	__( 'Ico Thumbnail', 'spiral' ),
				'preview'	=>	__( 'Small Thumbnail', 'spiral' ),
				'square'	=>	__( 'Square Thumbnail', 'spiral' ),
			]
		);
	}


	/**
	 * Добавление class="thumbnail img-thumbnail" к медиафайлам.
	 *
	 * @param string $html
	 * @return string $html
	 */
	final public function wp_attachment_link_class($html) {
		$html = str_replace('<a', '<a itemprop="thumbnailUrl" class="highslide-thumbnail"', $html);
		return $html;
	}


} // end ImgFix
?>