<?php
/**
 * Экспорт параметров контактных форм.
 *
 * Инструмент экспорта данных из контактных форм в Google Drive.
 *
 * @param object $gdrive
 * @param object $forms_data
 * @param object $product_data
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class GdriveExportForm {


	/**
	 * Инструменты работы с Google Spreadsheets.
	 * @type obj
	 */
	private $gdrive;
	/**
	 * Инструменты обработки POST данных из форм.
	 * @type obj
	 */
	private $forms_data;
	/**
	 * Инструменты из плагина товаров.
	 * @type obj
	 */
	private $product_data;


	public function __construct( &$gdrive, &$forms_data, &$product_data ) {

		// Объект инструментов Google Spreadsheets
		if( !$gdrive && !is_object($gdrive) ) {
			throw new \Exception('No Google tools obj!');
		}
		// Запись объекта в свойство
		$this->gdrive = $gdrive;

		// Объект обработки POST данных из форм
		if( !$forms_data && !is_object($forms_data) ) {
			throw new \Exception('No Post data obj!');
		}
		// Запись объекта в свойство
		$this->forms_data = $forms_data;

		// Объект обработки POST данных из форм
		if( $product_data && is_object($product_data) ) {
			// Запись объекта в свойство
			$this->product_data = $product_data;
		}
	}


/////////////////// Публичные методы ////////////////////


	/**
	 * Обертка для сохранения данных формы.
	 *
	 * @param void
	 * @return void
	 */
	final public function save_form_data() {
		// Рзвертывание
		$this->load();
	}


//////////////////// Приватные методы ////////////////////


	/**
	 * Обертка для сохранения данных формы.
	 *
	 * @param void
	 * @return void
	 */
	private function load() {

		// Модификация POST массива, добавление текущей даты
		$now = new DateTime();
		$this->forms_data->inject_post_var( 'sendingdate', $now->format('Y-m-d H:i:s') );

		// Подключение GDrive
		// Имя листа
		$sheet_title = $this->forms_data->options['mail_title'];

		// Загрузка Google tools
		$this->gdrive->load_gdrive('forms_gdrive',$sheet_title);

		// Заполнение пустых значений
		foreach( $this->forms_data->fields as $key => $value ) {
			if( !isset($this->forms_data->post_data[$key]) ) {
				$post_data[$key] = '';
			} else {
				$post_data[$key] = $this->forms_data->post_data[$key];
			}
		}

		// Требуется запись заголовков (Новый лист)
		if( $this->gdrive->is_new_sheet() || empty($this->gdrive->get_file_fields()) ) {
			// Конструктор заголовков для текущей формы
			$headers = $this->sheet_header_construct( $post_data );
			// Запись заголовков в созданный лист
			$this->gdrive->set_sheet_headers( $headers );
		}

		// Добавление текущих данных в объект gdrive
		// Дополнение таблицы данными из текущей формы
		$this->gdrive->add_row_data($post_data);
		// Запись обновленной таблицы в файл
		$this->gdrive->write_file_data();

		// Форма заказа? Сохраняем так же заказы из сессии
		$this->load_cart_to_gdrive();
	}


	/**
	 * Сохранение данных корзины в таблицу GDrive.
	 *
	 * @param void
	 * @return void
	 */
	private function load_cart_to_gdrive() {
		// Проверка наилчия данных заказа, если есть номер корзины
		if( !isset($this->forms_data->post_data['cart']) ) {
			return true;
		}
		$this->product_data->init();
		// Загрузка Google tools
		$this->gdrive->load_gdrive('forms_gdrive', __('Orders','shop'));

		// Требуется запись заголовков (Новый лист)
		if( $this->gdrive->is_new_sheet() || empty($this->gdrive->get_file_fields()) ) {
			// Конструктор заголовков для текущей формы
			$first_cart_key = key($_SESSION['gdrive']);
			$first_cart = $this->product_data->get_resurected_cart_item($_SESSION['gdrive'][$first_cart_key]);
			$first_cart = array_merge(['cart'=>'','passport'=>'','customer'=>''], $first_cart);
			$headers = $this->sheet_header_construct( $first_cart );
			// Запись заголовков в созданный лист
			$this->gdrive->set_sheet_headers( $headers );
		}

		// Добавление текущих данных в объект gdrive
		// Дополнение таблицы данными из текущей корзины
		$this->product_data->init();
		foreach( $_SESSION['gdrive'] as $cart ){
			// Количество прeбразуется в отдельные строки в таблице
			$quantity = (int)$cart['quantity'];
			// Обработка массива корзины
			$cart = $this->product_data->get_resurected_cart_item($cart);
			$personal_info = [
				'cart'		=>	$this->forms_data->post_data['cart'],
				'passport'	=>	'',
				'customer'	=>	$this->forms_data->post_data['customer'],
			];
			$cart = array_merge( $personal_info, $cart );
			// Запись в таблицу указанное чило раз в поле quantity
			for( $i = 0; $i < $quantity; $i++ ) {
				$this->gdrive->add_row_data($cart);
			}
		}
		// Запись обновленной таблицы в файл
		$this->gdrive->write_file_data();
	}


	/**
	 * Преобразование данных форм в массив для заголовков листа таблицы.
	 * 
	 * @param array $input_data
	 * @return array
	 */
	private function sheet_header_construct($input_data) {

		// Массив для сортировки полей по блокам
		// Каждый отдельный блок записывется в элемент массива
		$result_set = [ 0=>[], 1=>[] ];

		// (1) Проход цикла по массиву входных даннх
		foreach( $input_data as $post_name => $post_value ) {
			// (2) Проход цикла по массивам текстовых значений (названий полей) для поиска совпадений индексов массивов
			foreach( $this->forms_data->labels as $block_name => $text_data ) {
				// (3) Проход цикла по массиву названий полей для поиска совпадений
				foreach( $text_data as $label_name => $label ) {
					// Совпадение индексов массивов пост данных и имен полей
					if( $post_name == $label_name ) {
						// Запись значений
						array_push( $result_set[0], $label_name);
						array_push( $result_set[1], $label);
					} // end if
				} // end foreach (3)
			} // end foreach (2)
		} // end foreach (1)
		// Результат
		return $result_set;
	}


} //end GdriveExportForm