<?php
/**
 * Социальные сети.
 * 
 * Парсинг соцсеей из из базы.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsSocial extends ContactsGet {


	public function __construct() {
		$this->data = [];
		//Получение адресов соцсетей из параметров WP.
		$this->load_social_networks();
	}


//////////////////// Публичные методы ////////////////////



//////////////////// Приватные методы ////////////////////


	/**
	 * Получение сылок на соцсети из параметров WP.
	 *
	 * @param void
	 * @return void
	 */
	private function load_social_networks() {
		// Массив иконок
		$symbolic = [
			'social_vk'			=>	'fa-vk',
			'social_fb'			=>	'fa-facebook',
			'social_in'			=>	'fa-linkedin',
			'social_pinterest'	=>	'fa-pinterest-p',
			'social_gplus'		=>	'fa-google-plus',
			'social_youtube'	=>	'fa-youtube',
			'social_instagram'	=>	'fa-instagram',
		];
		// Массив иконок
		$square = [
			'social_vk'			=>	'fa-vk',
			'social_fb'			=>	'fa-facebook-square fa-2x',
			'social_in'			=>	'fa-linkedin-square fa-2x',
			'social_pinterest'	=>	'fa-pinterest-square fa-2x',
			'social_gplus'		=>	'fa-google-plus-square fa-2x',
			'social_youtube'	=>	'fa-youtube-square fa-2x',
			'social_instagram'	=>	'fa-instagram fa-2x',
		];

		// Массив флагов составных иконок
		$stacked = [
			'social_vk'			=>	true,
			'social_fb'			=>	false,
			'social_in'			=>	false,
			'social_pinterest'	=>	false,
			'social_gplus'		=>	false,
			'social_youtube'	=>	false,
			'social_instagram'	=>	false,
		];

		// Массив заголовков
		$titles = [
			'social_vk'			=>	'Vkontakte',
			'social_fb'			=>	'FaceBook',
			'social_in'			=>	'LinkedIn',
			'social_pinterest'	=>	'Pinterest',
			'social_gplus'		=>	'+Google',
			'social_youtube'	=>	'YouTube',
			'social_instagram'	=>	'Instagram',
		];

		// Соцсети из параметров
		foreach( $titles as $key => $title ) {
			$url = get_option($key);
			if( !$url ) {
				continue;
			}
			// Результат
			$this->data[$key]['url'] = $url;
			$this->data[$key]['ico'] = $symbolic[$key];
			$this->data[$key]['square'] = $square[$key];
			$this->data[$key]['stacked'] = $stacked[$key];
			$this->data[$key]['title'] = $title;
		}
	}


} // end ContactsSocial
?>