<?php
/**
 * Телефоны.
 * 
 * Формирует разметку контактных данных.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsGeneratorPhones {


	use FileHandling, TemplatesLoad;


	/**
	 * Объект телефонов.
	 * @type obj
	 */
	private $phones;
	/**
	 * Объект почтовых адресов.
	 * @type obj
	 */
	private $emails;
	/**
	 * Массив параметров.
	 * @type array
	 */
	private $options;
	/**
	 * Результат работы.
	 * @type string
	 */
	private $result_set;


	public function __construct( &$phones = false, &$emails = false ) {

		/**
		 * Объект телефонов.
		 */
		if( $phones && is_object($phones) ) {
			$this->phones = $phones;
		}
		/**
		 * Объект почтовых адресов.
		 */
		if( $emails && is_object($emails) ) {
			$this->emails = $emails;
		}

		// Список всех указанных телефонов.
		add_action( 'all_phones_list', [$this, 'get_all_phones_list'], 1, 0 );
		// Телефон в хедере с поповером

		// Список всех указанных телефонов две колонки для записи в аргумент кавычки заменены на &quot;
		add_action( 'all_phones_list_two_columns', [$this, 'get_all_phones_two_columns'], 1, 0 );
		// Все блоки телефонов сортированных по подписи.
		add_action( 'get_sorted_phones', [$this, 'get_sorted_phones'], 1, 0 );
		// Блок телефонов сортированных по подписи.
		add_action( 'get_sorted_phones_block', [$this, 'get_sorted_phones_block'], 1, 0 );
		// Один телефон в обертке.
		add_action( 'one_phone_number', [$this, 'get_one_phone_number'], 1, 0 );
		// Телефон в хедере с вызовом модального окна.
		add_action( 'one_phone_head', [$this, 'get_one_phone_head'], 1, 0 );
		// Телефон в меню.
		add_action( 'one_phone_nav', [$this, 'get_one_phone_nav'], 1, 0 );
		// Телефон в меню (мобильная версия).
		add_action( 'one_phone_nav_link', [$this, 'get_one_phone_nav_link'], 1, 0 );
		// Телефон в лендинге.
		add_action( 'one_phone_slide', [$this, 'get_one_phone_slide'], 1, 0 );
		// Просто телефон ссылкой.
		add_action( 'one_phone_link', [$this, 'get_one_phone_link'], 1, 0 );
		// Телефоны в лендинге.
		add_action( 'many_phones_slide', [$this, 'get_many_phones_slide'], 1, 0 );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Список всех указанных телефонов.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_all_phones_list() {
		// Формирование разметки
		$this->set_all_phones_list();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Список всех указанных телефонов без микроразметки.
	 *
	 * @param void
	 * @return string
	 */
	public function get_all_phones_list_simple() {
		// Формирование разметки
		$this->set_all_phones_list(false);
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Список всех указанных телефонов в две колонки, адаптив.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_all_phones_two_columns() {
		// Формирование разметки
		$this->set_all_phones_two_columns();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Блоки телефонов сортированных по подписи.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_sorted_phones() {
		// Формирование разметки
		$this->set_sorted_phones();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Один блок телефонов сортированных по подписи.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_sorted_phones_block() {
		// Формирование разметки
		$this->set_sorted_phones_block();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Основной телефон в обертке.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_phone_number() {
		// Формирование разметки
		echo $this->html_phone('master','phone_number',true,false);
	}


	/**
	 * Основной телефон в шапке сайта.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_phone_head() {
		// Формирование разметки
		echo $this->html_phone('master','phone_modal',true,false);
	}


	/**
	 * Основной телефон в верхнем меню.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_phone_nav() {
		// Формирование разметки
		echo $this->html_phone('master','phone_nav',true,false);
	}


	/**
	 * Основной телефон в верхнем меню.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_phone_nav_link() {
		// Формирование разметки
		echo $this->html_phone('master','phone_nav_link',true,false);
	}


	/**
	 * Основной телефон в слайдах, без микроразметки.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_phone_slide() {
		// Формирование разметки
		echo $this->html_phone('master','phone_landing',true,false);
	}


	/**
	 * Основной телефон простой сслыкой, без микроразметки.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_phone_link() {
		// Формирование разметки
		echo $this->html_phone('master','phone_link',true,false);
	}


	/**
	 * список телефонов в слайдах, без микроразметки.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_many_phones_slide() {
		// Формирование разметки
		$this->set_landing_phones();
		// Вывод результата
		echo $this->result_set;
	}


//////////////////// Приватные методы ////////////////////


	/**
	 * Разметка телефонов.
	 * Получение списка всех указанных телефонов.
	 *
	 * @param bool $microdata
	 * @return void
	 */
	private function set_all_phones_list($microdata = true) {
		$result_set = '';
		$this->phones->get_load();
		$phones = $this->phones->data;
		// Номер факса переносим в конец массива
		if( isset($phones['fax_number']) ) {
			$fax_number = $phones['fax_number'];
			unset($phones['fax_number']);
			$phones['fax_number'] = $fax_number;
		}
		// Проход по массиву
		foreach( $phones as $key => $phone ) {
			$result_set .= $this->html_phone($key,'phone_number',true,$microdata);
		}
		$this->result_set = $result_set;
	}


	/**
	 * Разметка телефонов.
	 * Список всех указанных телефонов для всплывающей подсказки.
	 * Разметка для записи в атрибут, символы кавычек заменены &quot;
	 *
	 * @param bool $microdata
	 * @return void
	 */
	private function set_all_phones_two_columns($microdata = true) {
		$result_set = '';
		// Если хоть один телефон существует
		$master_phone = $this->phones->get_one_array();
		if( $master_phone && is_array($master_phone) ) {
			// Шаблоны разметки для телефонов
			$this->options['files']['phone_number'] = 'phone_number.php';
			$this->options['files']['phone_popover'] = 'phone_popover.php';
			$first = 0;
			$phone_sanitized = '';
			$popover = '';
			foreach( $this->phones->data as $key => $phone ) {
				// Начало разметки всплывающего окна
				if( $first === 0 ) {
					$popover .= '
								<div id=&quot;contact-phones-popover&quot;>
									<div class=&quot;row&quot;>
										<div class=&quot;col-sm-6&quot;>
					';
				}
				// Середина разметки всплывающего окна
				if( $first === 3 ) {
					$popover .= '
										</div>
										<div class=&quot;col-sm-6&quot;>
					';
				}
				// Очередной номер телефона
				$phone_item = $this->html_phone($key,'phone_number',true,$microdata);
				// Замена маркеров и дозапись результата
				$popover .= str_replace( '"', '&quot;', $phone_item );
				$first++;
			}
			// Конец разметки всплывающего окна
			if( (bool)$first ) {
				$popover .= '
										</div>
									</div>
								</div>
				';
			}
			// Мессив замен для основной разметки телефона со ссылкой и попапом
			$replacement['phone_title'] =		get_bloginfo('name') . ' - ' . __('Contact phone number', 'spiral' );
			$replacement['phone_sanitized'] =	'+38&nbsp;' . $master_phone['phone_sanitized'];
			$replacement['ico'] =				$master_phone['ico'];
			$replacement['popover'] =			$popover;
			$replacement['business_hours'] =	get_option('public_business_hours');
			// Замена маркеров и запись результата
			$result_set .= $this->template_replacement( $replacement, 'phone_popover', 'contacts' );
		}
		$this->result_set = $result_set;
	}


	/**
	 * Разметка телефонов.
	 * Получение сортированных по названию списков телефонов.
	 * Текже в конец списка добавляется адрес почты если подпись совпадает.
	 *
	 * @param bool $microdata
	 * @return void
	 */
	private function set_sorted_phones($microdata = true) {

		$result_set = '';
		$this->phones->get_load();
		$sorted = $this->phones->get_sorted_array();
		// Не пуст ли массив сортированных телефонов
		if( !$sorted || empty($sorted) ) {
			return NULL;
		}
		// Разметка подзаголовка
		$this->options['files']['block_contact'] = 'block_contact.php';
		foreach( $sorted as $sort ) {
			// Подзаголовок
			$result_set .= $this->template_replacement( ['subtitle'=>$sort['title']], 'block_contact', 'contacts' );
			// Проход по массиву телефонов
			foreach( $sort['ids'] as $key ) {
				// Разметка телефона
				$result_set .= $this->html_phone($key,'phone_number');
			}
			// Поиск адеса почты
			$email = $this->emails->get_one_sorted($sort['title']);
			$result_set .= $this->html_email($email,'email_address',true);
		}
		// Результат
		$this->result_set = $result_set;

	}


	/**
	 * Разметка телефонов.
	 * Получение одного из блоков сортированного по названию списка телефонов.
	 *
	 * @param bool $microdata
	 * @return void
	 */
	private function set_sorted_phones_block($microdata = true) {
		static $flag = 0;
		$result_set = '';
		$this->phones->get_load();
		$sorted = $this->phones->get_sorted_array();
		// Не пуст ли массив сортированных телефонов
		if( !$sorted || empty($sorted) ) {
			return NULL;
		}
		// Есть ли текущий элемент массива
		if( !isset($sorted[$flag]) || empty($sorted[$flag]) || empty($sorted[$flag]['ids']) ) {
			return NULL;
		}
		// Подзаголовок
		$this->options['files']['block_contact'] = 'block_contact.php';
		$result_set .= $this->template_replacement( ['subtitle'=>$sorted[$flag]['title']], 'block_contact', 'contacts' );
		// Проход по массиву телефонов
		foreach( $sorted[$flag]['ids'] as $key ) {
			// Разметка телефона
			$result_set .= $this->html_phone($key,'phone_number');
		}
		// Поиск адеса почты
		$email = $this->emails->get_one_sorted($sorted[$flag]['title']);
		if( $email ) {
			$result_set .= $this->html_email($email,'email_address');
		}
		// Результат
		$this->result_set = $result_set;
		$flag++;
	}


	/**
	 * Разметка телефонов.
	 * Список всех указанных телефонов строкой (адаптив).
	 *
	 * @param void
	 * @return void
	 */
	private function set_landing_phones() {
		$result_set = '';
		// Если хоть один телефон существует
		$master_phone = $this->phones->get_one_array();
		if( !$master_phone || !is_array($master_phone) ) {
			$this->result_set = '';
			return true;
		}

		// Шаблоны разметки для телефонов
		$selector = [
			1 => 'col-sm-12',
			2 => 'col-sm-12 col-md-6',
			3 => 'col-sm-12 col-md-4',
		];
		$length = $this->phones->length;
		if( $length > 3 ) {
			$length = 3;
		}
		$counter = 1;
		// Начало разметки
		$result_set .= '
						<div class="row">
		';
		foreach( $this->phones->data as $key => $phone ) {
			// Открывающий тег
			$result_set .= '
							<div class="'.$selector[$length].'">
			';
			// Очередной номер телефона
			$result_set .= $this->html_phone($key,'phone_landing',true,false);
			// Закрывающий тег
			$result_set .= '
							</div>
			';
			$counter++;
			if( $counter >= 3 ) {
				break;
			}
		}
		// Конец разметки всплывающего окна
		$result_set .= '
						</div>
		';
		$this->result_set = $result_set;
	}



	/**
	 * Вспомогательный метод.
	 * Разметка телефона.
	 *
	 * @param string $key
	 * @param string $template
	 * @param bool|string $title
	 * @param bool $microdata
	 * @return void
	 */
	private function html_phone($key,$template,$title = true,$microdata = true) {
		// Шаблон разметки для телефона
		if( !isset($this->options['files'][$template]) ) {
			$this->options['files'][$template] = $template . '.php';
		}
		// Мастер телефон ?
		if( $key == 'master' ) {
			// Если хоть один телефон существует
			$phone = $this->phones->get_one_array();
		} else {
			// Телефон по ключу
			$phone = $this->phones->data[$key];
		}

		// Исключение
		if( NULL == $phone || !$phone || !is_array($phone) ) {
			return '';
		}

		// Заголовок
		if( $title === true ) {
			$phone_title = $phone['translate'];
		} elseif( is_string($title) && $title != '' ) {
			$phone_title = $title;
		} else {
			$phone_title = get_bloginfo('name') . ' - ' . __('Contact phone number', 'spiral' );
		}
		// Телефон как есть?
		if( (bool)get_option('public_phones_view') ) {
			$number	= $phone['as_is'];
			$html	= $phone['as_is_html'];
		} else {
			$number	= $phone['phone_sanitized'];
			$html	= $phone['phone_html'];
		}
		
		// Массив замен маркеров в шаблоне телефона
		$replacement['phone_title']		=	$phone_title;
		$replacement['phone_cleaned']	=	$phone['phone_cleaned'];
		$replacement['phone_sanitized']	=	$number;
		$replacement['phone_html']		=	$html;
		$replacement['ico']				=	$phone['ico'];
		$replacement['microdata']		=	' itemprop="telephone"';
		$replacement['business_hours']	=	get_option('public_business_hours');
		if( !$microdata ) {
			$replacement['microdata']	=	'';
		}
		// Замена маркеров
		return $this->template_replacement( $replacement, $template, 'contacts' );
	}


	/**
	 * Вспомогательный метод.
	 * Разметка почты.
	 *
	 * @param string $key
	 * @param string $template
	 * @param bool|string $title
	 * @param bool $microdata
	 * @return void
	 */
	private function html_email($email,$template,$title = true,$microdata = true) {
		// Шаблоны разметки для почты
		$this->options['files'][$template] = $template . '.php';
		// Передан пустой массив
		if( !$email || empty($email) ) {
			return '';
		}
		// Заголовок
		if( $title === true ) {
			$email_title = $email['rem'];
		} elseif( is_string($title) && $title != '' ) {
			$email_title = $title;
		} else {
			$email_title = $email['rem'] . ': ' . __('Write a letter', 'spiral' ) . ' - ' . get_bloginfo('name');
		}

		// Мессив замен
		$replacement['email']		=	$email['email'];
		$replacement['ico']			=	$email['ico'];
		$replacement['title']		=	$email_title;
		$replacement['microdata']		=	' itemprop="email"';
		if( !$microdata ) {
			$replacement['microdata']	=	'';
		}
		// Замена маркеров и запись результата
		return $this->template_replacement( $replacement, $template, 'contacts' );
	}

} // end ContactsGeneratorPhones
?>