<?php
/**
 * Адрес почты.
 * 
 * Формирует разметку контактных данных.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsGeneratorEmails {


	use FileHandling, TemplatesLoad;


	/**
	 * Объект почтовых адресов.
	 * @type obj
	 */
	private $emails;
	/**
	 * Регистр - флаги и данные необходимые для работы.
	 * @type array
	 */
	public $registry = [];
	/**
	 * Массив параметров.
	 * @type array
	 */
	private $options;
	/**
	 * Результат работы.
	 * @type string
	 */
	private $result_set;


	public function __construct( &$emails = false ) {

		/**
		 * Объект почтовых адресов.
		 */
		if( $emails && is_object($emails) ) {
			$this->emails = $emails;
		}

		// Один ящик с микроразметкой.
		add_action( 'microdata_one_email', [$this, 'get_one_microdata_email'], 1, 0 );
		// Один ящик без микроразметки.
		add_action( 'no_microdata_one_email', [$this, 'get_one_no_microdata_email'], 1, 0 );
		// Адреса с микроразметкой.
		add_action( 'microdata_email', [$this, 'get_microdata_email'], 1, 0 );
		// Полный адрес с микроразметкой.
		add_action( 'microdata_full_email', [$this, 'get_microdata_full_email'], 1, 0 );

	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Один адрес почты с микроразметкой.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_microdata_email() {
		// Состояние системы
		$this->registry['microdata'] = true;
		$this->registry['simplified'] = false;
		$this->registry['single'] = true;
		// Результат
		echo $this->emails_generator();
	}


	/**
	 * Один адрес почты без микроразметки.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_no_microdata_email() {
		// Состояние системы
		$this->registry['microdata'] = true;
		$this->registry['simplified'] = false;
		$this->registry['single'] = true;
		// Результат
		echo $this->emails_generator();
	}


	/**
	 * Адреса почты с микроразметкой.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_microdata_email() {
		// Состояние системы
		$this->registry['microdata'] = true;
		$this->registry['simplified'] = true;
		$this->registry['single'] = false;
		// Результат
		echo $this->emails_generator();

	}


	/**
	 * Полные адреса почты с микроразметкой.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_microdata_full_email() {
		// Состояние системы
		$this->registry['microdata'] = true;
		$this->registry['simplified'] = false;
		$this->registry['single'] = false;
		// Результат
		echo $this->emails_generator();
	}


//////////////////// Приватные методы ////////////////////



	/**
	 * Разметка почтового адреса.
	 *
	 * @param void
	 * @return string $result_set
	 */
	private function emails_generator() {
		// Проверка
		if( !is_array($this->emails->data) ) {
			return '';
		}
		// Шаблоны разметки для почты
		$this->options['files']['email'] = 'email_address.php';
		$this->options['files']['email_text'] = 'email_text.php';
		// Разметка
		$result_set = '';

		foreach( $this->emails->data as $email ) {
			// Упрощенный режим без подписей
			if( !$this->registry['simplified'] && (bool)$email['rem'] ) {
				// Мессив замен
				$replacement['text']	=	$email['rem'] . ': ';
				// Замена маркеров и запись результата
				$result_set .= $this->template_replacement( $replacement, 'email_text', 'contacts' );
			}
			// Мессив замен
			$replacement['email']		=	$email['email'];
			$replacement['ico']			=	$email['ico'];
			$replacement['title']		=	__('Write a letter', 'spiral' ) . ' - ' . get_bloginfo('name');
			if( (bool)$email['rem'] ) {
				$replacement['title']	=	$email['rem'] . ': ' . $replacement['title'];
			}
			$replacement['microdata']		=	' itemprop="email"';
			if( !$this->registry['microdata'] ) {
				$replacement['microdata']	=	'';
			}
			// Замена маркеров и запись результата
			$result_set .= $this->template_replacement( $replacement, 'email', 'contacts' );

			// Один ящик?
			if( $this->registry['single'] ) {
				break;
			}
		}
		return $result_set;
	}


} // end ContactsGeneratorEmails
?>