<?php
/**
 * Адрес.
 * 
 * Формирует разметку контактных данных.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsGeneratorAddress {


	use FileHandling, TemplatesLoad;


	/**
	 * Объект адреса.
	 * @type obj
	 */
	private $address;
	/**
	 * Объект телефонов.
	 * @type obj
	 */
	private $phones;
	/**
	 * Объект почтовых адресов.
	 * @type obj
	 */
	private $emails;
	/**
	 * Регистр - флаги и данные необходимые для работы.
	 * @type array
	 */
	public $registry = [];
	/**
	 * Массив параметров.
	 * @type array
	 */
	private $options;
	/**
	 * Результат работы.
	 * @type string
	 */
	private $result_set;


	public function __construct( &$address = false, &$phones = false, &$emails = false ) {

		/**
		 * Объект адреса.
		 */
		if( $address && is_object($address) ) {
			$this->address = $address;
		}
		/**
		 * Объект телефонов.
		 */
		if( $phones && is_object($phones) ) {
			$this->phones = $phones;
		}
		/**
		 * Объект почтовых адресов.
		 */
		if( $emails && is_object($emails) ) {
			$this->emails = $emails;
		}

		// Адрес с микроразметкой.
		add_action( 'microdata_address', [$this, 'get_microdata_address'], 1, 0 );
		// Полный адрес с микроразметкой.
		add_action( 'microdata_full_address', [$this, 'get_microdata_full_address'], 1, 0 );
		// Микроразметка организации для блога.
		add_action( 'microdata_organization', [$this, 'get_microdata_organization'], 1, 0 );
		// Разметка данных для маркера карты.
		add_action( 'organization_map_data', [$this, 'get_organization_map_data'], 1, 0 );
		add_action( 'organization_map_data_offset', [$this, 'get_organization_map_data_offset'], 1, 0 );
		// Разметка данных для маркера карты.
		add_action( 'multiple_contacts_map_data', [$this, 'get_multiple_contacts_map_data'], 1, 0 );
		// Разметка данных для страницы контектов.
		add_action( 'multiple_contacts_data', [$this, 'get_multiple_contacts_data'], 1, 0 );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Адрес с микроразметкой.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_microdata_address() {
		// Формирование разметки
		$this->set_microdata_address();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Полный адрес с микроразметкой.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_microdata_full_address() {
		// Формирование разметки
		$this->set_microdata_full_address();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Микроразметка организации для блога.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_microdata_organization() {
		// Формирование разметки
		$this->set_microdata_organization();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Разметка данных для маркера карты.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_organization_map_data() {
		// Формирование разметки
		$this->set_organization_map_data();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Разметка данных для маркера карты.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_organization_map_data_offset() {
		// Формирование разметки
		$this->set_organization_map_data('offset');
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Разметка данных для маркеров карты.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_multiple_contacts_map_data() {
		// Формирование разметки
		$this->set_multiple_contacts_map_data();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Разметка данных для страницы контактов.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_multiple_contacts_data() {
		// Формирование разметки
		$this->set_multiple_contacts_data();
		// Вывод результата
		echo $this->result_set;
	}


//////////////////// Приватные методы ////////////////////


	/**
	 * Разметка адреса с микроразметкой.
	 * Разметка для футеров.
	 *
	 * @param void
	 * @return void
	 */
	private function set_microdata_address() {
		// Требуемый массив
		unset($this->registry['data_set']);
		$this->registry['data_set'] = [
			//'business_hours'	=>	'microdata',
			'name'				=>	'microdata',
			'address'			=>	'microdata',
			'url'				=>	'meta',
			'logo'				=>	'meta',
		];
		// Состояние системы
		//$this->registry['simplified'] = true;
		// Формирование данных
		$this->list_construct();
	}


	/**
	 * Разметка адреса с микроразметкой.
	 * Разметка для футеров.
	 *
	 * @param void
	 * @return void
	 */
	private function set_microdata_full_address() {
		// Требуемый массив
		unset($this->registry['data_set']);
		$this->registry['data_set'] = [
			'name'				=>	'microdata',
			'address'			=>	'microdata',
			'business_hours'	=>	'microdata',
			'url'				=>	'meta',
			'logo'				=>	'meta',
		];
		// Состояние системы
		//$this->registry['simplified'] = false;
		// Формирование данных
		$this->list_construct();
	}


	/**
	 * Микроразметка организации для блога.
	 * Разметка для футеров.
	 *
	 * @param void
	 * @return void
	 */
	private function set_microdata_organization() {
		// Требуемый массив
		unset($this->registry['data_set']);
		$this->registry['data_set'] = [
			'name'				=>	'meta',
			'phone'				=>	'meta',
			'address'			=>	'meta',
			'logo'				=>	'meta',
		];
		// Состояние системы
		//$this->registry['simplified'] = true;
		// Формирование данных
		$this->list_construct();
		// Шаблоны разметки названия (обертка микроразметки организации)
		$this->options['files']['organization'] = 'organization_blog.php';
		// Замена маркеров и запись результата
		$this->result_set = $this->template_replacement( ['microdata'=>$this->result_set], 'organization', 'contacts' );
	}


	/**
	 * Разметка данных для маркера карты.
	 * Разметка для футеров.
	 *
	 * @param string $map
	 * @return void
	 */
	private function set_organization_map_data( $map='normal' ) {

		// Получение координат
		$map_latitude = get_option('map_latitude');
		$map_longitude = get_option('map_longitude');

		// Нет координат
		if( !$map_latitude || $map_latitude == '' || !$map_longitude || $map_longitude == '' ) {
			$this->result_set = '';
			return NULL;
		}
		$data = '';

		// Координаты
		$data = ' data-lat="' . $map_latitude . '" data-lng="' . $map_longitude . '"';

		// Маркер
		$map_marker = get_option('map_marker');
		$map_marker = $this->icon_construct($map_marker);
		if( $map_marker != '' ) {
			$data .= ' data-icon="' . $map_marker . '"';
		}

		// Зум
		$zoom = get_option('map_zoom');
		if( !$zoom || $zoom == '' ) {
			$zoom = 15;
		}
		$data .= ' data-zoom="' . $zoom . '"';

		// Email
		$email = $this->emails->get_one_string();
		if( $email && $email != '' ) {
			$data .= ' data-email="' . $email . '"';
		}

		// Телефон
		$phone = $this->phones->get_one_string();
		if( $phone && $phone != '' ) {
			$data .= ' data-phone="' . $phone . '"';
		}

		// Адрес
		if( $this->address->full && $this->address->full != '' ) {
			$data .= ' data-address="' . $this->address->full . '"';
		}

		// Часы работы
		$hours = get_option('public_business_hours');
		if( $hours && $hours != '' ) {
			$data .= ' data-hours="' . $hours . '"';
		}

		// Заголовок
		$title = get_option('map_title');
		if( !$title && $title == '' ) {
			$title = get_option('blogname');
		}
		if( $title && $title != '' ) {
			$data .= ' data-title="' . $title . '"';
		}

		// Название
		$data .= ' data-name="' . get_option('blogname') . '"';

		// Описание
		$description = get_option('map_description');
		if( !$description && $description == '' ) {
			$description = get_option('blogdescription');
		}
		if( $description && $description != '' ) {
			$data .= ' data-description="' . $description . '"';
		}


		// Отступ и высота, если указаны, для карты со слоем контактов
		if( $map == 'offset' ) {
			$offset = get_option('map_offset');
			if( NULL != $offset && '' != $offset ) {
				$data .= ' data-offset="' . $offset . '"';
			}
			$height = get_option('map_height');
			if( NULL != $height && '' != $height ) {
				$data .= ' data-height="' . $height . '"';
			}
		}

		// Идентификаторы (задан отступ)
			$id = 'map-contacts';
		if( $map == 'offset' ) {
			$id = 'map-contacts-offset';
		}

		// Селекторы
		if( is_page_template('landing.php') ) {
			$class = 'slide-footer slide-footer-contacts';
		} else {
			$class = 'slide-page-contacts scroll-section';
		}

		// Массив замен
		$replacement = [
			'id'		=>	$id,
			'class'		=>	$class,
			'data'		=>	$data,
			'map_data'	=>	'',
			
		];
		// Шаблоны разметки для карты
		$this->options['files']['map'] = 'map_wrapper.php';
		// Замена маркеров и запись результата
		$this->result_set = $this->template_replacement( $replacement, 'map', 'contacts' );
	}



	/**
	 * Разметка данных для маркеров карты.
	 * Разметка для стьраницы контактов.
	 *
	 * @param void
	 * @return void
	 */
	private function set_multiple_contacts_map_data() {

		$this->result_set = '';
		if( !file_exists( TEMPLATEPATH . '/conf/maps_custom.php' ) ) {
			return false;
		}

		require TEMPLATEPATH . '/conf/maps_custom.php';

		// Данные маркеров
		$map_data = '';
		foreach( $maps as $map ) {

			// Нет координат
			if( !$map['lat'] || $map['lat'] == '' || ! $map['lng'] || $map['lng'] == '' ) {
				continue;
			}

			$item = '';
			foreach( $map as $key => $data ) {
				if( $key == 'icon' ) {
					$data = $this->icon_construct($data);
				} elseif ( $key == 'zoom' ) {
					if( !$data || $data == '' ) {
						$data = 15;
					}
				}
				$item .= ' data-' . $key . '="' . $data . '"';
			}
			$map_data .= PHP_EOL . '<div'. $item . '></div>';
		}

		// Селекторы
		if( is_page_template('landing.php') ) {
			$class = 'slide-footer slide-footer-contacts';
		} else {
			$class = 'slide-page-contacts scroll-section';
		}

		// Массив замен
		$replacement = [
			'id'		=>	'map-contacts-multiple',
			'class'		=>	$class,
			'data'		=>	'',
			'map_data'	=>	$map_data,
			
		];
		// Шаблоны разметки для карты
		$this->options['files']['map'] = 'map_wrapper.php';
		// Замена маркеров и запись результата
		$this->result_set = $this->template_replacement( $replacement, 'map', 'contacts' );
	}



	/**
	 * Разметка данных множественных контактов.
	 * Разметка для страницы контактов.
	 *
	 * @param void
	 * @return void
	 */
	private function set_multiple_contacts_data() {

		$this->result_set = '';
		if( !file_exists( TEMPLATEPATH . '/conf/maps_custom.php' ) ) {
			return false;
		}

		$ico = [
			'address'		=>	'fa-map-marker',
			'title'			=>	'fa-flag',
			'name'			=>	'fa-flag',
			'description'	=>	'fa-info',
			'url'			=>	'fa-link',
			'phone'			=>	'fa-phone',
			'email'			=>	'fa-envelope-o',
			'hours'			=>	'fa-clock-o',
		];
		$style = [
			'hours'			=>	'margin-bottom:0;',
		];
		// Шаблоны разметки
		$this->options['files']['multiple_item'] = 'multiple_item.php';
		$this->options['files']['multiple_item_line'] = 'multiple_item_line.php';

		require TEMPLATEPATH . '/conf/maps_custom.php';

		// Данные
		foreach( $maps as $map ) {
			$items = '';
			foreach( $map as $key => $data ) {
				// Неиспользуемые элементы
				if( in_array( $key, ['icon','lat','lng','description'] ) ) {
					continue;
				}
				
				// Массив замен
				$replacement = [
					'data'	=>	$data,
					'ico'	=>	$ico[$key],
					'style'	=>	isset($style[$key])?' style="'.$style[$key].'"':'',
				];
				// Замена маркеров и запись результата
				$items .= $this->template_replacement( $replacement, 'multiple_item_line', 'contacts' );
			}
			// Массив замен
			$replacement = [
				'items'	=>	$items,
			];
			// Замена маркеров и запись результата
			$this->result_set .= $this->template_replacement( $replacement, 'multiple_item', 'contacts' );
		}

	}


//////////////////// Вспомогательные методы ////////////////////


	/**
	 * Сборка списка.
	 *
	 * @param void
	 * @return void
	 */
	private function list_construct() {
		$this->result_set = '';
		// Формирование данных
		foreach( $this->registry['data_set'] as $item => $type ) {
			// Формирование имени метода.
			$method_name = $item . '_construct';
			// Тип разметки
			if( (bool)$type ) {
				$type = '_' . $type;
			}
			// Имя файла
			$file = $item . $type;
			// Шаблон разметки названия
			$this->options['files'][$file] = $file . '.php';
			// Вызов соответствующего метода для сбора данных.
			if( method_exists( $this, $method_name ) ) {
				$this->result_set .= $this->{$method_name}($file);
			}
		}
	}


	/**
	 * Разметка названия компании.
	 *
	 * @param string $file
	 * @return string
	 */
	private function name_construct($file='') {
		// Проверка
		$name = get_bloginfo('name');
		if( !(bool)$name ) {
			return '';
		}		
		// Замена маркеров и запись результата
		return $this->template_replacement( ['name'=>$name], $file, 'contacts' );
	}


	/**
	 * Разметка адреса.
	 *
	 * @param string $file
	 * @param bool $microdata
	 * @return string
	 */
	private function address_construct($file='',$microdata=false) {
		// Проверка
		if( !$this->address->full ) {
			return '';
		}
		$this->options['files']['address_item']	=	'address_item.php';
		// Разметка
		$list = '';
		if( $microdata ) {
			foreach( $this->address->data as $address ) {
				// Мессив замен
				$replacement['itemprop']		=	$address['type'];
				$replacement['address_item']	=	$address['item'];
				// Замена маркеров и запись результата
				if( !empty($list) ) {
					$list .= ', ';
				}
				$list .= $this->template_replacement( $replacement, 'address_item', 'contacts' );
			}
		} else {
			$list = $this->address->full;
		}
		// Мессив замен
		$replacement['address'] = $list;
		// Замена маркеров и запись результата
		return $this->template_replacement( $replacement, $file, 'contacts' );
	}


	/**
	 * Разметка ремени работы.
	 *
	 * @param string $file
	 * @return string
	 */
	private function business_hours_construct($file='') {
		// Проверка
		if( !$this->address->business_hours ) {
			return '';
		}
		// Замена маркеров и запись результата
		return $this->template_replacement( ['business_hours'=>$this->address->business_hours], $file, 'contacts' );
	}


	/**
	 * Разметка ссылки.
	 *
	 * @param string $file
	 * @return string
	 */
	private function url_construct($file='') {
		// Проверка
		$url = get_bloginfo('url');
		if( !(bool)$url ) {
			return '';
		}
		// Замена маркеров и запись результата
		return $this->template_replacement( ['url'=>$url], $file, 'contacts' );
	}


	/**
	 * Разметка лого.
	 *
	 * @param string $file
	 * @return string
	 */
	private function logo_construct($file='') {
		// Проверка

		if( file_exists(TEMPLATEPATH . '/assets/img/logo.svg') ) {
			$replacement['src'] = TEMPLATE_URL . '/assets/img/logo.svg';
		} elseif( file_exists(TEMPLATEPATH . '/assets/img/logo.png') ) {
			$replacement['src'] = TEMPLATE_URL . '/assets/img/logo.png';
		} elseif( file_exists(TEMPLATEPATH . '/assets/img/logo.jpg') ) {
			$replacement['src'] = TEMPLATE_URL . '/assets/img/logo.jpg';
		} else {
			return '';
		}
		// Мессив замен
		list($replacement['width'], $replacement['height']) = getimagesize($replacement['src']);
		$replacement['alt'] = get_bloginfo('name');
		// Замена маркеров и запись результата
		return $this->template_replacement( $replacement, $file, 'contacts' );
	}


	/**
	 * Разметка маркера.
	 *
	 * @param string $file
	 * @return string
	 */
	private function icon_construct($file='') {
		// Проверка
		if( !$file || $file == '' ) {
			if( file_exists(TEMPLATEPATH . '/assets/img/map_marker.svg') ) {
				$file = TEMPLATE_URL . '/assets/img/map_marker.svg';
			} elseif( file_exists(TEMPLATEPATH . '/assets/img/map_marker.png') ) {
				$file = TEMPLATE_URL . '/assets/img/map_marker.png';
			} elseif( file_exists(TEMPLATEPATH . '/assets/img/ico/favicon-32x32.png') ) {
				$file = TEMPLATE_URL . '/assets/img/ico/favicon-32x32.png';
			}
		}
		return $file;
	}


	/**
	 * Разметка телефона.
	 *
	 * @param string $file
	 * @return string
	 */
	private function phone_construct($file='') {
		// Проверка
		$phone = $this->phones->get_one_string();
		if( !(bool)$phone ) {
			return '';
		}
		// Замена маркеров и запись результата
		return $this->template_replacement( ['phone'=>$phone], $file, 'contacts' );
	}


} // end ContactsGeneratorAddress
?>