<?php
/**
 * Почтовые адреса.
 * 
 * Парсинг адресов почты из из базы.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsEmails extends ContactsGet {


	public function __construct() {
		$this->data = [];
		//Получение адресов почты из параметров WP.
		$this->load_emails();
		// Хук получения телефон виде строки
		add_filter( 'one_email_construct', [$this, 'get_one_string'] );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Основной email виде строки.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_string() {
		// Вывод результата
		return $this->the_one_email_string();
	}


	/**
	 * Основной email виде строки.
	 *
	 * @param string $sign
	 * @return array
	 */
	public function get_one_sorted($sign) {
		// Вывод результата
		return $this->the_one_email_sorted($sign);
	}


//////////////////// Приватные методы ////////////////////


	/**
	 * Получение почтовых адресов из параметров WP.
	 *
	 * @param void
	 * @return void
	 */
	private function load_emails() {
		// Массив иконок
		$options = [
			'public_email'		=>	'fa-envelope-o',
			'public_email2'		=>	'fa-envelope-o',
			'public_email3'		=>	'fa-envelope-o',
			'admin_email'		=>	'fa-envelope',
		];

		// Тлефоны из параметров
		$flag = false;
		foreach( $options as $key => $ico ) {
			// Если нет адресов, то берем админский
			if( $flag && $key == 'admin_email' ) {
				continue;
			}
			$email = get_option($key);
			if( !$email ) {
				continue;
			}
			$flag = true;
			// Результат
			$this->data[$key]['email'] = $email;
			$this->data[$key]['ico'] = $ico;
			$rem = get_option($key . '_txt');
			if( !$rem || $rem == '' ) {
				$rem = false;
			}
			$this->data[$key]['rem'] = $rem;
		}
	}


	/**
	 * Основной email в виде строки.
	 *
	 * @param void
	 * @return string
	 */
	private function the_one_email_string() {

		// Если хоть один email существует
		foreach($this->data as $email) {
			if( $email['email'] && $email['email'] != '' ) {
				return $email['email'];
			}
		}
		return '';
	}


	/**
	 * Основной email в виде строки.
	 *
	 * @param string $sign
	 * @return array
	 */
	private function the_one_email_sorted($sign) {

		// Если хоть один email существует
		foreach($this->data as $email) {
			if( $email['email'] && $email['email'] != '' && $email['rem'] == $sign ) {
				return $email;
			}
		}
		return [];
	}


} // end ContactsEmails
?>