<?php
/**
 * Дополнительнае поля на странице категории.
 *
 * Элементы для сортировки.
 *
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

class AdminTaxSorting {

	/**
	 * Первичный объект модификации интерфейса категорий.
	 * @type object
	 */
	private $gui_taxonomy_kernel;


	public function __construct() {
		/**
		 * Добавляет произвольные поля для сортировки в таксономиях.
		 * Вызов функции при инициализации административного раздела.
		 */
		add_action( 'admin_init', [ $this, 'sorting_taxonomy_custom_fields'], 10 );
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'sorting_gui_taxonomy', [$this, 'get_taxonomy_kernel'], 10, 1 );
	}


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * Сортировка.
	 *
	 * @param object $gui_taxonomy_kernel
	 * @return void
	 */
	final public function get_taxonomy_kernel( $gui_taxonomy_kernel ){
		// Объект с общими методами в локальное свойство
		$this->gui_taxonomy_kernel = $gui_taxonomy_kernel;
	}


	/**
	 * функция расширения функционала административного раздела.
	 *
	 * Поля для сортировки во всех зарегистрированных таксономиях.
	 *
	 * @param void
	 * @return void
	 */
	final public function sorting_taxonomy_custom_fields() {

		foreach($this->gui_taxonomy_kernel->tax as $tax => $flag ) {
			if(!$flag) {
				continue;
			}
			// Добавления поля сортировки в рубрики и во все дополнительные таксономии переданные в родительский объект
			add_action( $tax . '_edit_form_fields', [ $this, 'sorting_custom_fields_form'], 10 );
		}
	}


	/**
	 * Вывод HTML разметки в таксономиях.
	 *
	 * @param obj $tag
	 * @return string
	 */
	final public function sorting_custom_fields_form($tag) {

		// Наименования параметров
		$filepath = TEMPLATEPATH . '/conf/tax_meta_sorting.php';
		if( !$this->gui_taxonomy_kernel->check_file($filepath) ) {
			return false;
		}
		require_once $filepath;

		// Никаких полей если масивы пусты
		if( empty($cat_fields) || empty($general) ) {
			return true;
		}

		// Вывод заголовка
		$this->gui_taxonomy_kernel->options_header($general);

		// Получение параметров
		$term_id = $tag->term_id;
		$cat_meta = get_term_meta( $term_id );

		// Вывод полей
		$this->gui_taxonomy_kernel->options_print( $cat_meta, $cat_fields, $cat_remarka, $restrict_write );

	}


} //end AdminTaxSorting