<?php
/**
 * Модификация интерфейса категорий.
 *
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

class AdminTaxKernel {

	/**
	 * Список опций.
	 * @type array
	 */
	private $options = [];
	/**
	 * Список зарегистрированных таксономий.
	 * @type array
	 */
	public $tax = [];


	public function __construct() {

		// Счетчик
		$this->options['counter'] = 0;
		/**
		 * Удаление фильтрации html тегов в описании таксономий
		 */
		remove_filter( 'pre_term_description', 'wp_filter_kses' );
		remove_filter( 'term_description', 'wp_kses_data' );
		/**
		 * Удаление стандартного редактора описания таксономии
		 */
		add_action( 'admin_head', [$this, 'remove_default_taxonomy_description'] );
		/**
		 * Передача текущего объекта в фильтр по ссылке для объктов использующих общие методы
		 */
		$recipients = ['category','hotels','catalog','realty','services','seo','sorting'];
		foreach( $recipients as $recipient ) {
			if( has_action( $recipient.'_gui_taxonomy' ) ) {
				do_action_ref_array( $recipient.'_gui_taxonomy', [&$this] );
			}
		}
	}


	/**
	 * Удаление стандартного редактора описания категорий
	 *
	 * @param void
	 * @return string
	 */
	final public function remove_default_taxonomy_description()
	{
		global $current_screen;
		if( $current_screen->base == 'term' )
		{
		?>
			<script type="text/javascript">
			jQuery(function($) {
				$('textarea#description').closest('tr.form-field').remove();
			});
			</script>
		<?php
		}
	}


	/**
	 * Добавление TinyMce редактора описания категорий
	 *
	 * @param object $tag
	 * @return string
	 */
	final public function taxonomy_description($tag)
	{
		?>
				<tr class="form-field">
					<th scope="row" valign="top"><label for="description"><?php _e('Description'); ?></label></th>
					<td>
					<?php
						$settings = array('wpautop' => true, 'media_buttons' => true, 'quicktags' => true, 'textarea_rows' => '15', 'tinymce' => false, 'textarea_name' => 'description' );
						wp_editor(wp_kses_post($tag->description , ENT_QUOTES, 'UTF-8'), 'cat_description', $settings);
					?>
					</td>
				</tr>
		<?php
	}


	/**
	 * Сохранение дополнительных полей в категории
	 *
	 * @param string $term_id
	 * @return void
	 */
	final public function taxonomy_custom_fields_save($term_id) {

		if (isset($_POST['cat_meta'])) {
			$t_id = $term_id;

			$cat_meta = get_term_meta( $term_id );

			$cat_keys = array_keys($_POST['cat_meta']);
			foreach ($cat_keys as $key) {
				if (isset($_POST['cat_meta'][$key])) {
					$new_cat_meta[$key] = $_POST['cat_meta'][$key];
				}
			}

			// Обработка старых значений (Записанных в дугую таблицу)
			$old_cat_meta = get_option("taxonomy_$term_id");
			if( isset($old_cat_meta) && !empty($old_cat_meta) ) {
				foreach( $old_cat_meta as $meta_key => $meta_value ) {
					// Создать/Обновить/Удалить
					if( $meta_value != '' ) {
						update_term_meta( $term_id, $meta_key, $meta_value );
					}
				}
				// Удаление значений
				update_option("taxonomy_$term_id", []);
			}

			// Обновление метаданных 
			if( !empty($new_cat_meta) ) {
				foreach( $new_cat_meta as $meta_key => $meta_value ) {
					// Создать/Обновить/Удалить
					if( $meta_value == '' ) {
						delete_term_meta( $term_id, $meta_key );
					} else {
						update_term_meta( $term_id, $meta_key, $meta_value );
					}
				}
			}
		}
	}


	/**
	 * Cодержание колонок списка категорий/таксономий.
	 *
	 * @param array $columns
	 * @return array
	 */
	final public function change_columns_list($columns) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
	//		'preview' => 'Превью'
			'name' => __('Name'),
	//		'description' => __('Description'),
			'slug' => __('Slug'),
			'posts' => __('Posts')
			);
		return $columns;
	}


////////////////////////////////////////////////////////////////////////////


	/**
	 * Проверка наличия конфигурационного файла.
	 *
	 * @param string $filepath
	 * @return echo|bool
	 */
	final public function check_file($filepath) {
		if( !file_exists($filepath) ) {
			?>

				<div id="setting-error-settings_updated" class="notice notice-error is-dismissible">
					<p><strong>No configuration file!</strong></p>
					<button type="button" class="notice-dismiss">
						<span class="screen-reader-text">Close message.</span>
					</button>
				</div>
			<?php
			return false;
		}
		return true;
	}


	/**
	 * Вывод заголовка дополнительного поля.
	 *
	 * @param array $general
	 * @return echo
	 */
	final public function options_header($general) {
	?>
		<tr class="form-field" style="margin-top:30px; margin-bottom:10px;" >
			<td style="padding:30px 0 15px 0;">
				<p style="background-color:#23282d; color:#fff; padding:10px;">
					<?php echo $general['name']; ?>
				</p>
			</td>
			<td style="padding:30px 0 15px 0;">
				<p style="background-color:#23282d; text-align:center; color:#fff; padding:10px;">
					<?php echo $general['description']; ?>
				</p>
			</td>
		</tr>
	<?php
	}


	/**
	 * Вывод строки дополнительного поля.
	 *
	 * @param array $cat_meta
	 * @param array $cat_fields
	 * @param array $cat_remarka
	 * @param array $restrict_write
	 * @return echo
	 */
	final public function options_print( $cat_meta, $cat_fields, $cat_remarka, $restrict_write ) {

		foreach( $cat_fields as $key => $name ) {
		?>

		<tr class="form-field">
			<th scope="row" valign="top">
				<label for="cat_meta[<?php echo $key; ?>]"><?php echo $name; ?></label>
			</th>
			<td>

				<?php if( isset($restrict_write[$key]) && (bool)$restrict_write[$key] ) { ?>

				<input type="hidden" name="cat_meta[<?php echo $key; ?>]" id="cat_meta[<?php echo $key; ?>]" value="<?php echo isset($cat_meta[$key][0]) ? $cat_meta[$key][0] : ''; ?>">
				<p><?php echo $cat_meta[$key]; ?></p>
				<?php } else { ?>

				<input type="text" name="cat_meta[<?php echo $key; ?>]" id="cat_meta[<?php echo $key; ?>]" value="<?php echo isset($cat_meta[$key][0]) ? $cat_meta[$key][0] : ''; ?>">
				<?php } ?>

				<?php if( $cat_remarka[$key] ) { ?>

				<br />
				<span class="description"><?php echo $cat_remarka[$key]; ?></span>
				<?php } ?>

			</td>
		</tr>

		<?php
		}
	}


} //end AdminTaxKernel