<?php
/**
 * Дополнительнае поля на странице рубрик
 *
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

class AdminTaxCategory {

	/**
	 * Первичный объект модификации интерфейса категорий.
	 * @type object
	 */
	private $gui_taxonomy_kernel;


	public function __construct() {
		/**
		 * Добавляет произвольные поля в таксономию "рубрики".
		 * Вызов функции при инициализации административного раздела.
		 */
		add_action( 'admin_init', [$this, 'category_custom_fields'], 10 );
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'category_gui_taxonomy', [$this, 'get_taxonomy_kernel'], 10, 1 );
	}


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * Категории, стандартная таксономия.
	 *
	 * @param object $gui_taxonomy_kernel
	 * @return void
	 */
	final public function get_taxonomy_kernel( $gui_taxonomy_kernel ){
		// Объект с общими методами в локальное свойство
		$this->gui_taxonomy_kernel = $gui_taxonomy_kernel;
		// Флаг в первичном объекте для родсвенных объектов (SEO, сортировка).
		$this->gui_taxonomy_kernel->tax['category'] = true;
	}


	/**
	 * функция расширения функционала административного раздела.
	 *
	 * Недвижимость
	 *
	 * @param void
	 * @return void
	 */
	final public function category_custom_fields() {
		// Добавления стандартных полей сортировки, как в рубриках
		add_filter( 'category_edit_form_fields', [$this->gui_taxonomy_kernel, 'taxonomy_description'], 1 );
		// Добавления действия при сохранении формы ввода параметров
		add_action( 'edited_category', [$this->gui_taxonomy_kernel, 'taxonomy_custom_fields_save'], 10 );
		// Cодержание колонок списка категорий недвижимости
		add_filter( 'manage_edit-category_columns', [$this->gui_taxonomy_kernel, 'change_columns_list'], 10 );
		// Добавления полей недвижимости
		add_action( 'category_edit_form_fields', [$this, 'category_custom_fields_form'], 10 );
	}


	/**
	 * Вывод HTML разметки в категории.
	 *
	 * @param object $tag
	 * @return string
	 */
	final public function category_custom_fields_form($tag) {

		// Наименования параметров
		$filepath = TEMPLATEPATH . '/conf/tax_meta_category.php';
		if( !$this->gui_taxonomy_kernel->check_file($filepath) ) {
			return false;
		}
		require_once $filepath;

		// Никаких полей если масивы пусты
		if( empty($cat_fields) || empty($general) ) {
			return true;
		}

		// Получение параметров
		$term_id = $tag->term_id;
		$cat_meta = get_term_meta( $term_id );
		//$cat_meta = get_option("category_$term_id");

		// Вывод заголовка
		$this->gui_taxonomy_kernel->options_header($general);

		// Вывод полей
		$this->gui_taxonomy_kernel->options_print( $cat_meta, $cat_fields, $cat_remarka, $restrict_write );

	}

} //end AdminTaxCategory