<?php
/**
 * Параметры шаблона
 *
 *
 * Основные параметры шаблона вынесены в админпанель.
 *
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class AdminOptionsTemplate extends AdminOptions {


	public function __construct() {
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'template_options_gui', [$this, 'get_options_gui'], 10, 1 );
		// Префикс
		$this->p = 'template';
	}


//////////////////// Защищенные методы ////////////////////


	/**
	 * Заголовки.
	 * Используются в родительском объекте для объявления страницы меню.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_page_data() {
		// Заголовки
		$this->gui->names['template']['title']		=	__('Template Settings', 'spiral' );
		$this->gui->names['template']['menu_title']	=	__('Template', 'spiral' );
		$this->gui->names['template']['prefix']		=	'template';
	}


	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sections_names() {
		$this->gui->sections['template']['common'] = [
			'title'			=> __('Common settings', 'spiral' ),
			'description'	=> __('Common template settings. Adjusts tools initialization.', 'spiral' ),
		];
		if( get_option('common_help_buttons') ) {
			$this->gui->sections['template']['btns'] = [
				'title'			=> __('Help Buttons', 'spiral' ),
				'description'	=> __('Auxiliary buttons for easier navigation and behavioral factors.', 'spiral' ),
			];
		}
		$this->gui->sections['template']['sidebar'] = [
			'title'			=> __('Side panels (Sidebars)', 'spiral' ),
			'description'	=> __('Included widgets are displayed in the standard list.', 'spiral' ),
		];
		$this->gui->sections['template']['gallery'] = [
			'title'			=> __('Advanced galleries', 'spiral' ),
			'description'	=> __('Parameters replace the standard display images in wordpress.', 'spiral' ),
		];
		$this->gui->sections['template']['head'] = [
			'title'			=> __('&lt;head&gt; build', 'spiral' ),
			'description'	=> __('Рarameters of &lt;head&gt; tag construction.', 'spiral' ),
		];
		$this->gui->sections['template']['var'] = [
			'title'			=> __('Template variables', 'spiral' ),
			'description'	=> __('File management is responsible for view.', 'spiral' ),
		];
		$this->gui->sections['template']['typ'] = [
			'title'			=> __('Thank you page', 'spiral' ), // Страница «Благодарим»
			'description'	=> __('Settings and content Thank you page.', 'spiral' ),
		];
	}


	/**
	 * Названия полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_names() {

		// Определени дополнительных полей.
		$this->gui->fields['template'] = [
			'common'					=>	__('Tools', 'spiral' ), // Подключать меню
			'btns'						=>	__('Help Buttons', 'spiral' ), // Вспомогательные кнопки
			'gallery_plain'				=>	__('Galleries', 'spiral' ), // Одиночные картинки bootstrap
			'gallery_type'				=>	__('Galleries type', 'spiral' ), // owl/bootstrap галерея
			'sidebar_enabled'			=>	__('Sidebar', 'spiral' ), // Подключать сайдбар
			'head_icons'				=>	__('Icons', 'spiral' ), // Иконки для мобильных устройств и браузеров
			'head_rss'					=>	__('RSS', 'spiral' ), // Ссылка на rss
			'head_cleanup'				=>	__('&lt;head&gt; cleanup', 'spiral' ), // Очистка секции head
			'var_header'				=>	__('Home header', 'spiral' ), // Заголовок
			'var_header_inner'			=>	__('Inner header', 'spiral' ), // Внутренний заголовок
			'var_header_landing'		=>	__('Landing header', 'spiral' ), // Заголовок лендинга
			'var_navbar'				=>	__('Home navbar', 'spiral' ), // Меню
			'var_navbar_fixed_top'		=>	'',
			'var_navbar_inner'			=>	__('Inner navbar', 'spiral' ), // Внутреннее меню
			'var_navbar_inner_fixed_top'=>	'',
			'var_navbar_landing'		=>	__('Landing navbar', 'spiral' ), // Меню в лендинге
			'var_navbar_second'			=>	__('Second navbar', 'spiral' ), // Дополнительное меню
			'var_navbar_second_inner'	=>	__('Inner second navbar', 'spiral' ), // Внутреннее дополнительное меню		
			'var_navbar_footer'			=>	__('Footer navbar', 'spiral' ), // Меню в футере
			'var_footer'				=>	__('Home footer', 'spiral' ), // Футер на главной
			'var_footer_inner'			=>	__('Inner footer', 'spiral' ), // Внутренний футер
			'var_sidebar'				=>	__('Sidebar', 'spiral' ), // Сайдбар
			'typ_title'					=>	__('Title', 'spiral' ), // 
			'typ_rem'					=>	__('Remarka', 'spiral' ), // 
			'typ_rem_ico'				=>	__('Remarka icon', 'spiral' ), // 
			'typ_primary'				=>	__('Primary message', 'spiral' ), // 
			'typ_primary_ico'			=>	__('Primary message icon', 'spiral' ), // 
			'typ_line1'					=>	__('Text line', 'spiral' ) . ' 1', // 
			'typ_line2'					=>	__('Text line', 'spiral' ) . ' 2', // 
			'typ_line3'					=>	__('Text line', 'spiral' ) . ' 3', // 
		];
	}


	/**
	 * Названия множественных полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sub_fields_names() {
		$this->gui->sub_fields['template'] = [
			'common'	=>	[
				'commerce'			=>	__('Commerce', 'spiral' ), // Страница "Коммерция"
				'seo'				=>	__('SEO', 'spiral' ), // Выключатель SEO
				'gdrive'			=>	__('Google Drive import', 'spiral' ), // Выключатель импорта данных из Google Drive
				'nav_menu'			=>	__('Nav Menu', 'spiral' ), // Подключать меню
				'nav_archives'		=>	__('Nav Archives', 'spiral' ), // Навигационные элементы в архивах
				'advanced_search'	=>	__('Advanced search', 'spiral' ), // Продвинутая форма поиска
				'modal_forms'		=>	__('Modal Forms', 'spiral' ), // Модальные окна
				'help_buttons'		=>	__('Help Buttons', 'spiral' ), // Вспомогательные кнопки вкл/выкл
				'star_rating'		=>	__('Star Rating', 'spiral' ), // Рейтинг статей - Звезды
				'views_count'		=>	__('Views Count', 'spiral' ), // Количество просмотров статьи
			],
			'btns'	=>	[
				'scrollup'			=>	__('Scroll up', 'spiral' ), // 
				'scrolldown'		=>	__('Scroll down', 'spiral' ), // 
				'search'			=>	__('Search form', 'spiral' ), // 
				'social'			=>	__('Social networks', 'spiral' ), // 
				'phones'			=>	__('Callback order form','spiral'), // 
				'binotel'			=>	__('Binotel','spiral'), // 
				'ask'				=>	__('Contact form','spiral'), // 
				'bug'				=>	__('Bug on the site','spiral'), // 
				'cart'				=>	__('Shoping cart','spiral'), // 
			],
			'gallery_plain'	=>	[
				0	=>	__('Single images with bootstrap markup', 'spiral' ),
				'highslide'		=>	__('Higslide library', 'spiral' ),
				'thumbnails'	=>	__('Thumbnails custom dimensions', 'spiral' ),
			],
			'gallery_type'	=>	[
				'bootstrap'		=>	__('Bootstrap', 'spiral' ),
				'owl'			=>	__('Owl', 'spiral' ),
			],
			'sidebar_enabled'	=>	[
				0			=>	__('Enabled', 'spiral' ), // Включено
				'posts'		=>	__('Posts widget', 'spiral' ), // Последние записи
				'products'	=>	__('Products widget', 'spiral' ), // Лента товаров
				'menu'		=>	__('Custom menu', 'spiral' ), // Произвольное меню
				'tax'		=>	__('Taxonomy menu', 'spiral' ), // Таксономия
			],
			'head_icons'	=>	[
				0	=>	__('Show icons for mobile and devices', 'spiral' ), // Показывать иконки для мобильных устройств
			],
			'head_rss'	=>	[
				0	=>	__('Show rss link', 'spiral' ), // Показать ссылку на RSS
			],
			'head_cleanup'	=>	[
				0							=>	__('Enabled', 'spiral' ), // Включено
				'exerpts'					=>	__('Read more link cleanup', 'spiral' ), // Изменить: Читать далее
				'wp_version'				=>	__('Remove WP version', 'spiral' ), // Убрать версию WP
				'rsd_link'					=>	__('Remove rsd link', 'spiral' ), // RSD ссылка
				'wlwmanifest_link'			=>	__('Remove wlw link', 'spiral' ), // wlw ссылка
				'rel_canonical'				=>	__('Remove canonical', 'spiral' ), // Убрать каноническую ссылку по умолчанию
				'adjacent_posts_rel_link'	=>	__('Remove prev/next page links', 'spiral' ), // Убрать ссылки на следующую и предыдущую страницы
				'feed_links_extra'			=>	__('Remove extra rss', 'spiral' ), // Убрать ссылки на фид
				'wp_shortlink_wp_head'		=>	__('Remove short link', 'spiral' ), // Убрать короткую ссылку
				'wp_emojicons'				=>	__('Remove emoji', 'spiral' ), // Убрать скрипт иконок
				'rest_api'					=>	__('Remove REST API', 'spiral' ), // Отключить json для получения данных из вне
			],
			'var_header'			=>		[
				0	=>	'masthead-navbar', // txt
			],
			'var_header_inner'		=>		[
				0	=>	'masthead-navbar', // txt
			],
			'var_header_landing'	=>		[
				0	=>	'masthead-navbar', // txt
			],
			'var_navbar'			=>		[
				0	=>	'top-nav', // txt
			],
			'var_navbar_fixed_top'			=>		[
				0	=>	__('Afix home menu', 'spiral' ), // Прилепить главное меню
			],
			'var_navbar_inner'			=>		[
				0	=>	'top-nav', // txt
			],
			'var_navbar_inner_fixed_top'			=>		[
				0	=>	__('Afix inner menu', 'spiral' ), // Прилепить главное меню
			],
			'var_navbar_landing'	=>		[
				0	=>	'top-nav', // txt
			],
			'var_navbar_second'		=>		[
				0	=>	'nav-empty', // txt
			],
			'var_navbar_second_inner'		=>		[
				0	=>	'top-nav-second', // txt
			],
			'var_navbar_footer'		=>		[
				0	=>	'bottom-nav', // txt
			],
			'var_footer'			=>		[
				0	=>	'standart', // txt
			],
			'var_footer_inner'		=>		[
				0	=>	'standart', // txt
			],
			'var_sidebar'			=>		[
				0	=>	'standart', // txt
			],
			'typ_title'				=>		[
				0	=>	'', // txt
			],
			'typ_rem'				=>		[
				0	=>	'', // txt
			],
			'typ_rem_ico'			=>		[
				0	=>	'', // txt
			],
			'typ_primary'			=>		[
				0	=>	'', // txt
			],
			'typ_primary_ico'		=>		[
				0	=>	'', // txt
			],
			'typ_line1'				=>		[
				0	=>	'', // txt
			],
			'typ_line2'				=>		[
				0	=>	'', // txt
			],
			'typ_line3'				=>		[
				0	=>	'', // txt
			],
		];
	}


	/**
	 * Типы полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_types() {
		$this->gui->fields_type['template'] = [
			'common'							=>	'checkbox',
			//'common_nav_menu'					=>	'checkbox',
			//'common_nav_archives'				=>	'checkbox',
			//'common_modal_forms'				=>	'checkbox',
			//'common_help_buttons'				=>	'checkbox',
			//'common_star_rating'				=>	'checkbox',
			//'common_like_button'				=>	'checkbox',
			//'common_views_count'				=>	'checkbox',
			//'common_csv'						=>	'checkbox',
			//'common_seo'						=>	'checkbox',
			'btns'								=>	'checkbox',
			'gallery_plain'						=>	'checkbox',
			//'gallery_plain_highslide'			=>	'checkbox',
			//'gallery_plain_thumbnails'		=>	'checkbox',
			'gallery_type'						=>	'radio',
			'sidebar_enabled'					=>	'checkbox',
			//'sidebar_enabled_posts'			=>	'checkbox',
			//'sidebar_enabled_products'		=>	'checkbox',
			//'sidebar_enabled_menu'			=>	'checkbox',
			//'sidebar_enabled_tax'				=>	'checkbox',
			'head_icons'						=>	'checkbox',
			'head_rss'							=>	'checkbox',
			'head_cleanup'						=>	'checkbox',
			//'head_cleanup_exerpts'				=>	'checkbox',
			//'head_cleanup_wp_version'				=>	'checkbox',
			//'head_cleanup_rsd_link'				=>	'checkbox',
			//'head_cleanup_wlwmanifest_link'		=>	'checkbox',
			//'head_cleanup_adjacent_posts_link'	=>	'checkbox',
			//'head_cleanup_feed_links_extra'		=>	'checkbox',
			//'head_cleanup_wp_shortlink_wp_head'	=>	'checkbox',
			//'head_cleanup_wp_emojicons'			=>	'checkbox',
			//'head_cleanup_rest_api'				=>	'checkbox',
			'var_header'						=>	'text',
			'var_header_inner'					=>	'text',
			'var_header_landing'				=>	'text',
			'var_navbar'						=>	'text',
			'var_navbar_fixed_top'				=>	'checkbox',
			'var_navbar_inner'					=>	'text',
			'var_navbar_inner_fixed_top'		=>	'checkbox',
			'var_navbar_second'					=>	'text',
			'var_navbar_second_inner'			=>	'text',
			'var_navbar_footer'					=>	'text',
			'var_navbar_landing'				=>	'text',
			'var_footer'						=>	'text',
			'var_footer_inner'					=>	'text',
			'var_sidebar'						=>	'text',
			'typ_title'							=>	'text',
			'typ_rem'							=>	'text',
			'typ_rem_ico'						=>	'text',
			'typ_primary'						=>	'text',
			'typ_primary_ico'					=>	'text',
			'typ_line1'							=>	'text',
			'typ_line2'							=>	'text',
			'typ_line3'							=>	'text',
		];
		$this->gui->fields_class['template'] = [
			'typ_title'							=>	'large-text',
			'typ_rem'							=>	'large-text',
			'typ_primary'						=>	'large-text',
			'typ_line1'							=>	'large-text',
			'typ_line2'							=>	'large-text',
			'typ_line3'							=>	'large-text',
		];
		// Скрытые
		if( !is_plugin_active( 'veselka_landing/veselka_landing.php' ) ) {
			if( !isset($this->gui->hidden['template']) || !is_array($this->gui->hidden['template']) ) {
				$this->gui->hidden['template'] = [];
			}
			array_push($this->gui->hidden['template'], 'var_header_landing','var_navbar_landing');
		}
	}


} // end AdminOptionsTemplate
?>