<?php
/**
 * Дополнительные параметры меню.
 *
 *
 * Добавление страницы с параметрами "Публичные" в меню 'Настройки'.
 * 1. Контактные данные.
 * 2. Соцсети.
 * 3. Параметры карты.
 *
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class AdminOptionsGeneral extends AdminOptions {


	public function __construct() {
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'general_options_gui', [$this, 'get_options_gui'], 30, 1 );
		// Префикс
		$this->p = 'general';
	}


//////////////////// Защищенные методы ////////////////////


	/**
	 * Заголовки.
	 * Используются в родительском объекте для объявления страницы меню.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_page_data() {
		$this->gui->names['general']['title']		=	__('Public Settings', 'spiral' );
		$this->gui->names['general']['menu_title']	=	__('Public', 'spiral' );
		$this->gui->names['general']['prefix']		=	'public';
	}


	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sections_names() {
		$this->gui->sections['general'] = [
			'public' => [
				'title'			=> __( 'Сontact data', 'spiral' ),
				'description'	=> __( 'Enter public contact details, which will be used on the site and will be visible to all visitors.', 'spiral' ),
			],
			'msg' => [
				'title'			=> __( 'Messengers', 'spiral' ),
				'description'	=> __( 'Contacts for sending messages via instant messengers.', 'spiral' ),
			],
			'social' => [
				'title'			=> __( 'Social Networks', 'spiral' ),
				'description'	=> __( 'Links to social networks. Will be displayed in the menu and footer.', 'spiral' ),
			],
			'map' => [
				'title'			=> __( 'Google map data', 'spiral' ),
				'description'	=> __( 'Data for displaying map directions online.', 'spiral' ),
			],
		];
	}


	/**
	 * Названия полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_names() {
		// Определени дополнительных полей.
		$this->gui->fields['general'] = [
			'public_phone_number'	=>	__('Phone number', 'spiral' ),
			'public_phone_txt'		=>	__('Phone number description', 'spiral' ),
			'public_phone_number2'	=>	__('Phone number', 'spiral' ),
			'public_phone2_txt'		=>	__('Phone number description', 'spiral' ),
			'public_phone_number3'	=>	__('Phone number', 'spiral' ),
			'public_phone3_txt'		=>	__('Phone number description', 'spiral' ),
			'public_mobile_number'	=>	__('Mobile number', 'spiral' ),
			'public_mobile_txt'		=>	__('Mobile number description', 'spiral' ),
			'public_mobile_number2'	=>	__('Mobile number', 'spiral' ),
			'public_mobile2_txt'	=>	__('Mobile number description', 'spiral' ),
			'public_mobile_number3'	=>	__('Mobile number', 'spiral' ),
			'public_mobile3_txt'	=>	__('Mobile number description', 'spiral' ),
			'public_fax_number'		=>	__('Fax number', 'spiral' ),
			'public_fax_txt'		=>	__('Fax description', 'spiral' ),
			'public_phones_view'	=>	__('Show as is', 'spiral' ),
			'public_email'			=>	__('Public email', 'spiral' ),
			'public_email_txt'		=>	__('Email description', 'spiral' ),
			'public_email2'			=>	__('Public email', 'spiral' ),
			'public_email2_txt'		=>	__('Email description', 'spiral' ),
			'public_email3'			=>	__('Public email', 'spiral' ),
			'public_email3_txt'		=>	__('Email description', 'spiral' ),	
			'public_contacts_sort'	=>	__('Sort contacts', 'spiral' ),
			'public_postal_code'	=>	__('Postal code', 'spiral' ),
			'public_localization'	=>	__('Localization', 'spiral' ),
			'public_address'		=>	__('Address', 'spiral' ),
			'public_business_hours'	=>	__('Business hours', 'spiral' ),
			'public_year'			=>	__('Year of foundation', 'spiral' ),
			'public_timezome'		=>	__('Timezone PHP', 'spiral' ),
			'msg_viber'				=>	__('Viber', 'spiral' ),
			'msg_viber_public'		=>	__('Viber', 'spiral' ) . ' ' . __('Public account', 'spiral' ),
			'msg_telegram'			=>	__('Telegram', 'spiral' ),
			'msg_whatsapp'			=>	__('Whatsapp', 'spiral' ),
			'msg_show'				=>	__('Show Messengers', 'spiral' ),
			'social_fb'				=>	__('FaceBook', 'spiral' ),
			'social_in'				=>	__('LinkedIn', 'spiral' ),
			'social_pinterest'		=>	__('Pinterest', 'spiral' ),
			'social_gplus'			=>	__('+Google', 'spiral' ),
			'social_youtube'		=>	__('YouTube', 'spiral' ),
			'social_instagram'		=>	__('Instagram', 'spiral' ),
			'social_vk'				=>	__('Vkontakte', 'spiral' ),			
			'map_api_key'			=>	__('Api key', 'spiral' ),
			'map_latitude'			=>	__('Latitude', 'spiral' ),
			'map_longitude'			=>	__('Longitude', 'spiral' ),
			'map_title'				=>	__('Map title', 'spiral' ),
			'map_description'		=>	__('Map description', 'spiral' ),
			'map_zoom'				=>	__('Map zoom (1-20)', 'spiral' ),
			'map_marker'			=>	__('Map marker', 'spiral' ),
			'map_offset'			=>	__('Marker offset', 'spiral' ),
			'map_height'			=>	__('Map height', 'spiral' ),
		];
	}


	/**
	 * Названия множественных полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sub_fields_names() {
		$this->gui->sub_fields['general'] = [
			'public_phone_number'	=>	[
				0	=>	'', // txt
			],
			'public_phone_txt'	=>	[
				0	=>	'', // txt
			],
			'public_phone_number2'	=>	[
				0	=>	'', // txt
			],
			'public_phone2_txt'	=>	[
				0	=>	'', // txt
			],
			'public_phone_number3'	=>	[
				0	=>	'', // txt
			],
			'public_phone3_txt'	=>	[
				0	=>	'', // txt
			],
			'public_mobile_number'	=>	[
				0	=>	'', // txt
			],
			'public_mobile_txt'	=>	[
				0	=>	'', // txt
			],
			'public_mobile_number2'	=>	[
				0	=>	'', // txt
			],
			'public_mobile2_txt'	=>	[
				0	=>	'', // txt
			],
			'public_mobile_number3'	=>	[
				0	=>	'', // txt
			],
			'public_mobile3_txt'	=>	[
				0	=>	'', // txt
			],
			'public_fax_number'		=>	[
				0	=>	'', // txt
			],
			'public_fax_txt'		=>	[
				0	=>	'', // txt
			],
			'public_phones_view'		=>	[
				0	=>	__('Show phones as it is written', 'spiral' ), // Показывать телефоны как есть
			],
			'public_email'			=>	[
				0	=>	'', // txt
			],
			'public_email_txt'		=>	[
				0	=>	'', // txt
			],
			'public_email2'			=>	[
				0	=>	'', // txt
			],
			'public_email2_txt'		=>	[
				0	=>	'', // txt
			],
			'public_email3'			=>	[
				0	=>	'', // txt
			],
			'public_email3_txt'		=>	[
				0	=>	'', // txt
			],
			'public_contacts_sort'		=>	[
				0	=>	__('Sort by description', 'spiral' ), // Сортировать по описанию
			],
			'public_postal_code'	=>	[
				0	=>	'', // txt
			],
			'public_localization'	=>	[
				0	=>	'', // txt
			],
			'public_address'		=>	[
				0	=>	'', // txt
			],
			'public_business_hours'	=>	[
				0	=>	'', // txt
			],
			'public_year'			=>	[
				0	=>	'', // txt
			],
			'public_timezome'		=>	[
				0	=>	'', // txt
			],
			'msg_viber'				=>	[
				0	=>	'', // txt
			],
			'msg_viber_public'		=>	[
				0	=>	'', // txt
			],
			'msg_telegram'			=>	[
				0	=>	'', // txt
			],
			'msg_whatsapp'			=>	[
				0	=>	'', // txt
			],
			'msg_show'				=>	[
				0	=>	__('Tags next to phones in contacts', 'spiral' ), // Пометки рядом с телефонами в контактах
			],
			'social_fb'				=>	[
				0	=>	'', // txt
			],
			'social_in'				=>	[
				0	=>	'', // txt
			],
			'social_pinterest'		=>	[
				0	=>	'', // txt
			],
			'social_gplus'			=>	[
				0	=>	'', // txt
			],
			'social_youtube'		=>	[
				0	=>	'', // txt
			],
			'social_instagram'		=>	[
				0	=>	'', // txt
			],
			'social_vk'				=>	[
				0	=>	'', // txt
			],
			'map_api_key'			=>	[
				0	=>	'', // txt
			],
			'map_latitude'			=>	[
				0	=>	'', // txt
			],
			'map_longitude'			=>	[
				0	=>	'', // txt
			],
			'map_title'				=>	[
				0	=>	'', // txt
			],
			'map_description'		=>	[
				0	=>	'', // txt
			],
			'map_zoom'				=>	[
				0	=>	'', // txt
			],
			'map_marker'			=>	[
				0	=>	'', // txt
			],
			'map_offset'			=>	[
				0	=>	'', // txt
			],
			'map_height'			=>	[
				0	=>	'', // txt
			],

		];
	}


	/**
	 * Типы полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_types() {
		$this->gui->fields_type['general'] = [
			'public_phone_number'	=>	'text',
			'public_phone_txt'		=>	'text',
			'public_phone_number2'	=>	'text',
			'public_phone2_txt'		=>	'text',
			'public_phone_number3'	=>	'text',
			'public_phone3_txt'		=>	'text',
			'public_mobile_number'	=>	'text',
			'public_mobile_txt'		=>	'text',
			'public_mobile_number2'	=>	'text',
			'public_mobile2_txt'	=>	'text',
			'public_mobile_number3'	=>	'text',
			'public_mobile3_txt'	=>	'text',
			'public_fax_number'		=>	'text',
			'public_fax_txt'		=>	'text',
			'public_phones_view'	=>	'checkbox',
			'public_email'			=>	'text',
			'public_email_txt'		=>	'text',
			'public_email2'			=>	'text',
			'public_email2_txt'		=>	'text',
			'public_email3'			=>	'text',
			'public_email3_txt'		=>	'text',
			'public_contacts_sort'	=>	'checkbox',
			'public_postal_code'	=>	'text',
			'public_localization'	=>	'text',
			'public_address'		=>	'text',
			'public_business_hours'	=>	'text',
			'public_year'			=>	'text',
			'public_timezome'		=>	'text',
			'msg_viber'				=>	'text',
			'msg_viber_public'		=>	'text',
			'msg_telegram'			=>	'text',
			'msg_whatsapp'			=>	'text',
			'msg_show'				=>	'checkbox',
			'social_fb'				=>	'text',
			'social_in'				=>	'text',
			'social_pinterest'		=>	'text',
			'social_gplus'			=>	'text',
			'social_youtube'		=>	'text',
			'social_instagram'		=>	'text',
			'social_vk'				=>	'text',
			'map_api_key'			=>	'text',
			'map_latitude'			=>	'text',
			'map_longitude'			=>	'text',
			'map_title'				=>	'text',
			'map_description'		=>	'text',
			'map_zoom'				=>	'text',
			'map_marker'			=>	'text',
			'map_offset'			=>	'text',
			'map_height'			=>	'text',
		];
	}

} // end AdminOptionsGeneral
?>