<?php
/**
 * Google Drive Import меню.
 *
 *
 * Добавление страницы с параметрами "GDrive" в меню 'Настройки'.
 * 1. Данные сервисного аккаунта.
 * 2. Идентификаторы страниц.
 * 3. Названия листов.
 *
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class AdminOptionsGdrive extends AdminOptions {


	public function __construct() {
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'gdrive_options_gui', [$this, 'get_options_gui'], 40, 1 );
		// Префикс
		$this->p = 'gdrive';
	}


//////////////////// Защищенные методы ////////////////////


	/**
	 * Заголовки.
	 * Используются в родительском объекте для объявления страницы меню.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_page_data() {
		$this->gui->names['gdrive']['title']			=	__('Google Drive Settings', 'spiral' );
		$this->gui->names['gdrive']['menu_title']		=	__('GDrive', 'spiral' );
		$this->gui->names['gdrive']['prefix']			=	'gdrive';
	}


	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sections_names() {
		$this->gui->sections['gdrive'] = [
			'drive' => [
				'title'			=> __( 'Service account data', 'spiral' ),
				'description'		=> __( 'Enter service account details, which will be used for connecting to google drive.', 'spiral' ),
			],
			'wp' => [
				'title'			=> __( 'WP pages', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for WP pages.', 'spiral' ),
			],
			'category' => [
				'title'			=> __( 'Native WP elements', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for native WP elements.', 'spiral' ),
			],
			'catalog' => [
				'title'			=> __( 'Products', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for products.', 'spiral' ),
			],
			'realty' => [
				'title'			=> __( 'Realty', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for realty.', 'spiral' ),
			],
			'hotels' => [
				'title'			=> __( 'Hotels', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for hotels.', 'spiral' ),
			],
			'options' => [
				'title'			=> __( 'Options', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for wp options import.', 'spiral' ),
			],
			'forms' => [
				'title'			=> __( 'Forms', 'spiral' ),
				'description'		=> __( 'Spreadsheets IDs and sheets titles for saving form data.', 'spiral' ),
			],
		];
		// Скрытые неактивных полей
		if( !post_type_exists('estate') ) {
			unset($this->gui->sections['gdrive']['realty']);
		}
		if( !post_type_exists('products') ) {
			unset($this->gui->sections['gdrive']['catalog']);
		}
		if( !post_type_exists('rooms') ) {
			unset($this->gui->sections['gdrive']['hotels']);
		}
	}


	/**
	 * Названия полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_names() {
		// Определени дополнительных полей.
		$this->gui->fields['gdrive'] = [
			'drive_credentials'			=>	__('Credentials path', 'spiral' ),
			'wp_gdrive_page_id'			=>	__('Pages spreadsheet ID', 'spiral' ),
			'wp_gdrive_page_title'			=>	__('Pages sheet title', 'spiral' ),
			'category_gdrive_post_id'		=>	__('Posts spreadsheet ID', 'spiral' ),
			'category_gdrive_post_title'		=>	__('Posts sheet title', 'spiral' ),
			'category_gdrive_id'			=>	__('Categories spreadsheet ID', 'spiral' ),
			'category_gdrive_title'			=>	__('Categories sheet title', 'spiral' ),
			'catalog_gdrive_products_id'		=>	__('Products spreadsheet ID', 'spiral' ),
			'catalog_gdrive_products_title'	=>	__('Products sheet title', 'spiral' ),
			'catalog_gdrive_id'			=>	__('Catalog spreadsheet ID', 'spiral' ),
			'catalog_gdrive_title'			=>	__('Catalog sheet title', 'spiral' ),
			'realty_gdrive_estate_id'		=>	__('Estate spreadsheet ID', 'spiral' ),
			'realty_gdrive_estate_title'		=>	__('Estate sheet title', 'spiral' ),
			'realty_gdrive_id'			=>	__('Realty spreadsheet ID', 'spiral' ),
			'realty_gdrive_title'			=>	__('Realty sheet title', 'spiral' ),
			'hotels_gdrive_rooms_id'		=>	__('Rooms spreadsheet ID', 'spiral' ),
			'hotels_gdrive_rooms_title'		=>	__('Rooms sheet title', 'spiral' ),
			'hotels_gdrive_id'			=>	__('Hotels spreadsheet ID', 'spiral' ),
			'hotels_gdrive_title'			=>	__('Hotels sheet title', 'spiral' ),

			'options_gdrive_id'			=>	__('Options spreadsheet ID', 'spiral' ),
			'options_gdrive_title'			=>	__('Options sheet title', 'spiral' ),

			'forms_gdrive_id'			=>	__('Forms spreadsheet ID', 'spiral' ),
		];
	}


	/**
	 * Названия множественных полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sub_fields_names() {
		$this->gui->sub_fields['gdrive'] = [
			'drive_credentials'				=>	[
				0	=>	'', // txt
			],
			'wp_gdrive_page_id'				=>	[
				0	=>	'', // txt
			],
			'wp_gdrive_page_title'			=>	[
				0	=>	'', // txt
			],
			'category_gdrive_post_id'		=>	[
				0	=>	'', // txt
			],
			'category_gdrive_post_title'	=>	[
				0	=>	'', // txt
			],
			'category_gdrive_id'			=>	[
				0	=>	'', // txt
			],
			'category_gdrive_title'			=>	[
				0	=>	'', // txt
			],
			'catalog_gdrive_products_id'	=>	[
				0	=>	'', // txt
			],
			'catalog_gdrive_products_title'	=>	[
				0	=>	'', // txt
			],
			'catalog_gdrive_id'				=>	[
				0	=>	'', // txt
			],
			'catalog_gdrive_title'			=>	[
				0	=>	'', // txt
			],
			'realty_gdrive_estate_id'		=>	[
				0	=>	'', // txt
			],
			'realty_gdrive_estate_title'	=>	[
				0	=>	'', // txt
			],
			'realty_gdrive_id'				=>	[
				0	=>	'', // txt
			],
			'realty_gdrive_title'			=>	[
				0	=>	'', // txt
			],
			'hotels_gdrive_rooms_id'		=>	[
				0	=>	'', // txt
			],
			'hotels_gdrive_rooms_title'		=>	[
				0	=>	'', // txt
			],
			'hotels_gdrive_id'				=>	[
				0	=>	'', // txt
			],
			'hotels_gdrive_title'			=>	[
				0	=>	'', // txt
			],
			'options_gdrive_id'				=>	[
				0	=>	'', // txt
			],
			'options_gdrive_title'			=>	[
				0	=>	'', // txt
			],
			'forms_gdrive_id'				=>	[
				0	=>	'', // txt
			],

		];
	}


	/**
	 * Типы полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_types() {
		$this->gui->fields_type['gdrive'] = [
			'drive_credentials'				=>	'text',
			'wp_gdrive_page_id'				=>	'text',
			'wp_gdrive_page_title'			=>	'text',
			'category_gdrive_post_id'		=>	'text',
			'category_gdrive_post_title'	=>	'text',
			'category_gdrive_id'			=>	'text',
			'category_gdrive_title'			=>	'text',
			'catalog_gdrive_products_id'	=>	'text',
			'catalog_gdrive_products_title'	=>	'text',
			'catalog_gdrive_id'				=>	'text',
			'catalog_gdrive_title'			=>	'text',
			'realty_gdrive_estate_id'		=>	'text',
			'realty_gdrive_estate_title'	=>	'text',
			'realty_gdrive_id'				=>	'text',
			'realty_gdrive_title'			=>	'text',
			'hotels_gdrive_rooms_id'		=>	'text',
			'hotels_gdrive_rooms_title'		=>	'text',
			'hotels_gdrive_id'				=>	'text',
			'hotels_gdrive_title'			=>	'text',
			'options_gdrive_id'				=>	'text',
			'options_gdrive_title'			=>	'text',
			'forms_gdrive_id'				=>	'text',

		];
		$this->gui->fields_class['gdrive'] = [
			'drive_credentials'				=>	'large-text',
			'wp_gdrive_page_id'				=>	'large-text',
			'category_gdrive_post_id'		=>	'large-text',
			'category_gdrive_id'			=>	'large-text',
			'catalog_gdrive_products_id'	=>	'large-text',
			'catalog_gdrive_id'				=>	'large-text',
			'realty_gdrive_estate_id'		=>	'large-text',
			'realty_gdrive_id'				=>	'large-text',
			'hotels_gdrive_rooms_id'		=>	'large-text',
			'hotels_gdrive_id'				=>	'large-text',
			'options_gdrive_id'				=>	'large-text',
			'forms_gdrive_id'				=>	'large-text',
		];

		// Скрытые неактивных полей
/*		if( !post_type_exists('estate') ) {
			array_push($this->gui->hidden['gdrive'], 'realty_gdrive_estate_id','realty_gdrive_estate_title','realty_gdrive_id','realty_gdrive_title');
		}
		if( !post_type_exists('products') ) {
			array_push($this->gui->hidden['gdrive'], 'catalog_gdrive_products_id','catalog_gdrive_products_title','catalog_gdrive_id','catalog_gdrive_title');
		}*/
	}

} // end AdminOptionsGDrive
?>