<?php
/**
 * Меню коммерции.
 *
 *
 * Добавление страницы с параметрами "Коммерция" в меню 'Настройки'.
 * 1. Курсы валют.
 * 2. 
 *
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class AdminOptionsCommerce extends AdminOptions {


	public function __construct() {
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'commerce_options_gui', [$this, 'get_options_gui'], 50, 1 );
		// Префикс
		$this->p = 'commerce';
	}


//////////////////// Защищенные методы ////////////////////


	/**
	 * Заголовки.
	 * Используются в родительском объекте для объявления страницы меню.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_page_data() {
		$this->gui->names['commerce']['title']			=	__('Commerce', 'spiral' );
		$this->gui->names['commerce']['menu_title']		=	__('Commerce', 'spiral' );
		$this->gui->names['commerce']['prefix']			=	'commerce';
	}


	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sections_names() {
		$this->gui->sections['commerce'] = [
			'currency' => [
					'title'			=> __( 'Exchange rates', 'spiral' ),
					'description'	=> __( 'The specified exchange rates will be used to transfer prices to the appropriate currency.', 'spiral' ),
			],
		];
	}


	/**
	 * Названия полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_names() {
		// Определени дополнительных полей.
		$this->gui->fields['commerce'] = [
			'currency_usd_buy'				=>	'USD ' . __('Purchase', 'spiral' ),
			'currency_usd_sell'				=>	'USD ' . __('Selling', 'spiral' ),
			'currency_eur_buy'				=>	'EUR ' . __('Purchase', 'spiral' ),
			'currency_eur_sell'				=>	'EUR ' . __('Selling', 'spiral' ),
		];
	}


	/**
	 * Названия множественных полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sub_fields_names() {
		$this->gui->sub_fields['commerce'] = [
			'currency_usd_buy'			=>	[
				0	=>	'', // txt
			],
			'currency_usd_sell'			=>	[
				0	=>	'', // txt
			],
			'currency_eur_buy'			=>	[
				0	=>	'', // txt
			],
			'currency_eur_sell'			=>	[
				0	=>	'', // txt
			],
		];
	}


	/**
	 * Типы полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_types() {
		$this->gui->fields_type['commerce'] = [
			'currency_usd_buy'				=>	'text',
			'currency_usd_sell'				=>	'text',
			'currency_eur_buy'				=>	'text',
			'currency_eur_sell'				=>	'text',
		];
		/*$this->gui->fields_class['commerce'] = [

		];*/

	}

} // end AdminOptionsCommerce
?>