<?php
/**
 * Инструменты шаблона.
 *
 * Все ситемные экземпляры объектов из каталога wp создаются в этом файле.
 * 
 *  
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */


////////////////// MAIN //////////////////


/**
 * Инициализация щаблона.
 */
$theme_init = new WpThemeInit('Veselka');

/**
 * Установка щаблона.
 * Единоразовый запуск для каждого экземпляра темы.
 * Регулируется флагом по названию.
 */
$theme_data = wp_get_theme();
if( get_option($theme_data['Name']) != 'installed' || get_option('current_theme') != $theme_data['Name'] ) {
	$theme_install = new WpThemeInstall($theme_data['Name']);
}

/**
 * Админка?
 */
if( is_admin() ) {

	/**
	 * Транслитерация урлов.
	 */
	$url_translit = new WpUrltranslit();

} else {

	/**
	 * Очистка от рудиментов блога wp_head()
	 */
	if( (bool)get_option('head_cleanup') ) {
		$clean_up = new WpCleanup();
	}

	/**
	 * Общий класс для формирования библиотек.
	 */
	$applications = new WpApplications();

	/**
	 * Формирование необходимого содержимого wp_head().
	 * Принимает в качесте аргумента объект LibConstruct.
	 */
	$wp_head = new WpThemeHead();

	/**
	 * Редирект шаблонов произвольных страниц.
	 * Вспомогательный объект, используется в плагинах.
	 */
	$template_redirect = new WpThemeRedirect();

	/**
	 * Общий класс для формирования библиотек.
	 */
	$lib_construct = new WpLibconstruct();

}

?>