<?php
/**
 * Инструменты шаблона.
 *
 * Все необходимые для работы экземпляры объектов из секции COMMON создаются в этом файле.
 * 
 *  
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */


////////////////// COMMON //////////////////


/**
 * Формирование меню.
 */
if( (bool)get_option('common_nav_menu') ) {
	$nav_menu = new NavMenu();
	if( $nav_menu && !is_admin() ) {
		// Подключение Волкера - содержит класс для формирования правильной структуры меню для Bootstrap
		require_once TEMPLATEPATH . '/lib/bootstrap_walker_nav_menu.php';
	}
}


/**
 * Пагинация в архивах.
 */
if( (bool)get_option('common_nav_archives') && !is_admin() ) {
	$nav_archives = new NavArchives();
}


/**
 * Расширенный поиск.
 */
if( (bool)get_option('common_advanced_search') && !is_admin() ) {
	$search_advanced = new Search();
}


/**
 * Формы.
 */
if( (bool)get_option('common_modal_forms') && !is_admin() ) {
	$forms_static = new FormsStatic();
}


/**
 * Вспомогательные кнопки.
 */
if( (bool)get_option('common_help_buttons') && !is_admin() ) {
	$help_buttons = new HelpButtons();
}


/**
 * Звездный рейтинг.
 */
if( (bool)get_option('common_star_rating') && !is_admin() ) {
	$star_rating = new RatingStarPrint();
}


/**
 * Количество просмотров записей.
 */
if( (bool)get_option('common_views_count') && !is_admin() ) {
	$views_counter = new RatingCounter();
}


/**
 * Изображения.
 */
if( (bool)get_option('gallery_plain') ) {

	/**
	 * Общие инструменты.
	 */
	$img_fix = new ImgFix();

	/**
	 * Галерея.
	 */
	if( get_option('gallery_type') == 'bootstrap' ) {
		$img_gallery_highslide = new ImgGalleryHighslide();
	} elseif( get_option('gallery_type') == 'owl' ) {
		$img_gallery_owl = new ImgGalleryOwl();
	}
}

/**
 * Иконки.
 */
if( !is_admin() ) {
	$img_icons = new ImgIcons();
}

/**
 * Боковая панель.
 */
if( (bool)get_option('sidebar_enabled') ) {
	$sidebar = new Sidebar();
}


?>