<?php
/**
 * Импорт информации из Google Drive
 * 
 * Серверная часть приложения. Получает данные из указанной таблицы Google Docs и сохраняет сортированные данные в базу WP.
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

// Типы постов, поддерфивающие загрузку
$post = [
	'post',
	'products',
	'estate',
	'rooms',
	'page',
];
// Типы таксономий, поддерживающие загрузку
$tax = [
	'category',
	'catalog',
	'realty',
	'hotels',
	'wp',
];

try{


	/**
	 * Инициализация Вордпресс.
	 */
	require_once '../../../../' . 'wp/wp-load.php';

	/**
	 * Google API.
	 */
	require_once '../../../../' . 'vendor/autoload.php';
	// Google API tools
	$gdrive_tools = new GdriveTools();

	// Поиск заполненных параметров для импорта
	foreach( $post as $key => $value ) {
		// Запись
		$option = $tax[$key] . '_gdrive_' . $post[$key] . '_id';
		$option = get_option($option);
		if( $option ) {
			//Импорт единичных записей
			$import_singular = new GdriveImportSingular( $gdrive_tools );
			// Попытка импорта записи с найденным параметром
			$import_singular->import_data($value);
		}
		// Таксономия
		$option = $tax[$key] . '_gdrive_id';
		$option = get_option($option);
		if( (bool)$option ) {
			//Импорт таксономий
			$import_tax = new GdriveImportTax( $gdrive_tools );
			// Попытка импорта таксономии с найденным параметром
			$import_tax->import_data($tax[$key]);
		}
	}


}
catch(Exception $e) {
	echo $e->getMessage();
}

?>