<?php
/**
 * Массивы с перечнями полей для контактных форм.
 *
 * Реализовано в виде php массивов. В дальнейшем возможна разрабтка веб интерфейса.
 * Обрабатывается экземпляром объекта MarketingSendMail. Без промежуточного инструмента обработки параметров.
 *
 * Индексы должны соответсвовать индексам из файла fields.php - так подтягиваются названия полей
 * Каждый элемент массива содержит массив с параметрами required(true), type(input), sign(''), dependence(false), hide_label(false)
 * Если элемент массива параметров не указан, считается что установлено значение по умолчанию
 * Если все параметы равны значениям по умолчанию, можно вообще не объявлять массив с параметрами.
 * В этом случае нужно установить соответствующее значение массива полей в true
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

/**
 * Умолчания
 * 
 * @type array
 */
$defaults = [
	'required'		=>	false, // обязательные для заполнения
	'type'			=>	'text', // тип поля
	'help_block'	=>	'', // подпись
	'dependence'	=>	false, // зависимое поле, нужно указать имя поля от которого зависит данное
	'custom_view'	=>	false, // использование уникального шаблона для отображения, нужно указать имя шаблона
	'row'			=>	false, // для применения указать true, поля должны идти по два один за другим иначе магии не получится
	'label_hide'	=>	false, // Спрятать лебл
	'data'			=>	[], // Дата атрибуты
];

/**
 * Статическая Контактная форма
 * 
 * @type array
 */
$static_contact = [
	'name'	=>	 [
		'required'	=>	true,
	],
	'email'	=>	[
		'required'	=>	true,
		'type'		=>	'email',
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'	=>	'tel',
	],
	'message'	=>	[
		'required'	=>	true,
		'type'		=>	'textarea',
	],
	'source'	=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Ask a Question','spiral'), // Задать вопрос
		'mail_title'	=>	__('Contact form','spiral'), // Контактная форма
		'button_title'	=>	__('Ask a Question','spiral'), // Задать вопрос
		'label_hide'	=>	true, // Скрыть лейблы
	],
];


/**
 * Статическая Контактная форма для главной (Формы одинаковые для сбора статистики по главной странице)
 * 
 * @type array
 */
$static_contact_home = [
	'name'	=>	 [
		'required'	=>	true,
	],
	'email'	=>	[
		'required'	=>	true,
		'type'		=>	'email',
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'		=>	'tel',
	],
	'message'	=>	[
		'required'	=>	true,
		'type'		=>	'textarea',
	],
	'source'	=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Ask a Question','spiral'), // Задать вопрос
		'mail_title'	=>	__('Contact form','spiral'), // Контактная форма
		'button_title'	=>	__('Ask a Question','spiral'), // Задать вопрос
		'label_hide'	=>	true, // Скрыть лейблы
	],
];


/**
 * Статическая Контактная форма "Заказ консультации"
 * 
 * @type array
 */
$static_consultation = [
	'phone'	=>	[
		'required'	=>	true,
		'type'	=>	'tel',
	],
	'source'	=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Order consultation','spiral'), // Заказать консультацию
		'mail_title'	=>	__('Order of consultation','spiral'), // Заказ консультации
		'button_title'	=>	__('Order consultation','spiral'), // Заказать консультацию
		'template'		=>	'static_string',
		'label_hide'	=>	true, // Скрыть лейблы
	],
];


/**
 * Статическая Контактная форма "Быстрый заказ"
 * 
 * @type array
 */
$static_fast_order = [
	'phone'	=>	[
		'required'	=>	true,
		'type'	=>	'tel',
	],
	'source'	=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Quick order','spiral'), // Быстрый заказ
		'mail_title'	=>	__('Quick order','spiral'), // Быстрый заказ
		'button_title'	=>	__('Quick order','spiral'), // Быстрый заказ
		'template'		=>	'static_string',
		'label_hide'	=>	true, // Скрыть лейблы
	],

];




/**
 * Контактная форма
 * 
 * @type array
 */
$modal_contact = [
	'name'	=>	 [
		'required'	=>	true,
	],
	'email'	=>	[
		'required'	=>	true,
		'type'		=>	'email',
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'		=>	'tel',
	],
	'message'	=>	[
		'required'	=>	true,
		'type'		=>	'textarea',
	],
	'source'	=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Ask a Question','spiral'), // Задать вопрос
		'mail_title'	=>	__('Contact form','spiral'), // Контактная форма
		'button_title'	=>	__('Send','spiral'), // Отправить
	],
];


/**
 * Обратный звонок
 * 
 * @type array
 */
$modal_ask = [
	'name'	=>	[
		'required'	=>	true,
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'	=>	'tel',
	],
	'source'	=>	[
		'type'	=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Request a call','spiral'), // Заказать звонок
		'mail_title'	=>	__('Call order','spiral'), // Заказ звонка
		'button_title'	=>	__('Send','spiral'), // Отправить
	],
];


/**
 * Узнать цены (Обратный звонок)
 * 
 * @type array
 */
$modal_price_order = [
	'name'	=>	 [
	],
	'email'	=>	[
		'type'		=>	'email',
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'		=>	'tel',
	],
	'source'=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Request prices','spiral'), // Узнать цены
		'mail_title'	=>	__('Price inquiry','spiral'), // Заказ цен
		'button_title'	=>	__('Send request','spiral'), // Отправить запрос
	],
];


/**
 * Заказ консультации (Обратный звонок)
 * 
 * @type array
 */
$modal_consultation_order = [
	'name'	=>	 [
		'required'	=>	true,
	],
	'email'	=>	[
		'required'	=>	true,
		'type'		=>	'email',
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'		=>	'tel',
	],
	'source'=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('Order consultation','spiral'), // Заказать консультацию
		'mail_title'	=>	__('Order of consultation','spiral'), // Заказ консультации
		'button_title'	=>	__('Send request','spiral'), // Отправить запрос
	],
];


/**
 * Заказ услуги
 * 
 * @type array
 */
$modal_service_order = [
	'service'	=>	[
		'required'	=>	true,
		'type'		=>	'select',
/*		'value'		=>	[
			'logo_design'		=>	'Дизайн логотипов',
			'automation'		=>	'Автоматизация',
			'programming'		=>	'Проектирование вебинтерфейсов',
			'copywriting'		=>	'Копирайтинг',
			'seo'				=>	'Продвижение сайтов',
			'budget_website'	=>	'Бюджетный сайт',
			'online_shop'		=>	'Создание интернет магазинов',
			'design_websites'	=>	'Дизайн сайтов',
		],*/
	],
	'comment'	=>	[
		'type'		=>	'textarea',
	],
/////////////////////////////////////////////
	'name'	=>	 [
		'required'	=>	true,
	],
	'email'	=>	[
		'required'	=>	true,
		'type'		=>	'email',
	],
	'phone'	=>	[
		'required'	=>	true,
		'type'		=>	'tel',
		'help_block'=>	__('Specify the phone number with the international code.','spiral'), // Номер телефона указывайте с международным кодом.
	],
	'source'	=>	[
		'type'		=>	'hidden',
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	true, // Показывать заголовки блоков полей
		'form_title'	=>	__('Order of service','spiral'), // Заказ услуги
		'mail_title'	=>	__('Order of service','spiral'), // Заказ услуги
		'button_title'	=>	__('To order','spiral'), // Заказать
	],
];


/**
 * Список телефонов
 * 
 * @type array
 */
$modal_phones_list = [
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	'',
		'mail_title'	=>	'',
		'button_title'	=>	__('Request a call','spiral'), // Заказать звонок
		'template'		=>	'modal_phones_list',
	],
];


/**
 * Форма входа
 * 
 * @type array
 */
$modal_login = [
	'login'	=>	[
		'type'		=>	'email',
		'required'	=>	true,
	],
	'password'	=>	[
		'type'		=>	'password',
		'required'	=>	true,
	],
/////////////////////////////////////////////
	'titles'	=>	[
		'block_title'	=>	false, // Показывать заголовки блоков полей
		'form_title'	=>	__('mark','spiral'), // Вход
		'mail_title'	=>	'',
		'button_title'	=>	__('mark','spiral'), // Войти
		'label_hide'	=>	true, // Скрыть лейблы
		'modal_size'	=>	'sm',
		'template'		=>	'modal_login',

	],
];



?>