<?php
/**
 * Массивы с именами и подсказками для полей контактных форм.
 * 
 * Реализовано в виде php массивов. В дальнейшем возможна разрабтка веб интерфейса.
 * Обрабатывается экземплярами объектов  SendMail и FormsTools. Без промежуточного инструмента обработки параметров.
 *
 * ВНИМАНИЕ!
 * Индексы во всех массивах *_labels жолжны быть уникальными!
 * Название поля в массиве *_labels должно иметь подсказку в массиве *_placeholders. Если подсказка не предусмотрена - значение должно быть пустой строкой.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

/**
 * Массив полей
 * 
 * @type array
 */
$fields = [];


/**
 * Названия полей контактной формы (Контактные данные).
 * 
 * @type array
 */
$fields['user_labels'] = [
	'block_title'	=>	__('Credentials','spiral'), // Учетные данные
	'login'			=>	__('Login','spiral'), // Логин
	'password'		=>	__('Password','spiral'), // Пароль
];


/**
 * Подсказки полей контактной формы (Контактные данные).
 * 
 * @type array
 */
$fields['user_placeholders'] = [
	'login'			=>	__('Username','spiral'), // Имя пользвоателя
	'password'		=>	__('Your password','spiral'), // Ваш пароль
];


/**
 * Названия полей контактной формы (Контактные данные).
 * 
 * @type array
 */
$fields['customer_labels'] = [
	'block_title'	=>	__('Contact details','spiral'), // Контактные данные
	'name'			=>	__('From','spiral'), // От
	'customer'		=>	__('Full name','spiral'), // ФИО
	'phone'			=>	__('Phone','spiral'), // Телефон
	'phone2'		=>	__('Phone','spiral'), // Доп. телефон
	'email'			=>	__('Email','spiral'), // Email
	'city'			=>	__('City','spiral'), // Город
	'address'		=>	__('Address','spiral'), // Адрес
	'time'			=>	__('Time','spiral'), // Время
	'organization'	=>	__('Organization','spiral'), // Организаця
	'message'		=>	__('Message','spiral'), // Cообщение
	'question'		=>	__('Sum','spiral'), // Сумма
];


/**
 * Подсказки полей контактной формы (Контактные данные).
 * 
 * @type array
 */
$fields['customer_placeholders'] = [
	'name'			=>	__('Your name','spiral'), // Ваше имя
	'customer'		=>	__('Your name','spiral'), // Ваше имя
	'phone'			=>	__('Contact phone','spiral'), // Контактный телефон
	'phone2'		=>	__('Additional Phone','spiral'), // Дополнительный телефон
	'email'			=>	__('Email Address','spiral'), // Адрес электронной почты
	'city'			=>	__('Your city','spiral'), // Ваш город
	'address'		=>	__('Contact address','spiral'), // Контактный адрес
	'time'			=>	__('Convenient time for a call','spiral'), // Удобное время для звонка
	'organization'	=>	__('Organization name','spiral'), // Название организации
	'message'		=>	__('Question or message text','spiral'), // Вопрос или текст сообщения
	'question'		=>	__('Enter the sum of numbers','spiral'), // Введите сумму чисел
];


/**
 * Названия полей контактной формы (Статистика).
 * 
 * @type array
 */
$fields['stat_labels'] = [
	'block_title'	=>	__('Statistics','spiral'), // Статистика
	'source'		=>	__('Form submission page','spiral'), // Страница отправки формы
	'sendingdate'	=>	__('Submission date','spiral'), // Дата отправки
];


/**
 * Подсказки полей контактной формы (Статистика).
 * 
 * @type array
 */
$fields['stat_placeholders'] = [
	'source'		=>	__('Form submission page','spiral'), // Страница отправки формы
	'sendingdate'	=>	__('Form submission date','spiral'), // Дата отправки
];


?>