/**
 * Evaluation of the material on the five point scale
 * 
 *
 * @author veselka.ua
 * @version 0.1
 * @modify: 31-10-2017
 */

var starRating = (function ($) {
	$.runStarRating = {

		/**
		 * Properties
		 */
		ratingId:	'',
		mode:		'',
		rating:		'',

		element:	'',
		starId:		'',
		starNum:	'',
		wpId:		'',
		votes:		'',


		/**
		 * Verification codes
		 */
		proof:
		{
			save:		'166c4ec6b541f604df0c3f70ecca17ad',
			answer:		'7c7d65d534452cf0568a6ee80ee77244',
		},


		/**
		 * Init Rating
		 */
		initRating: function ()
		{
			// Initiate rating actions
			this.starRatingActions();
		},


		/**
		 * Initiate rating actions
		 */
		starRatingActions: function()
		{
			var _this = this;
			// Set rating
			$('body').on('mouseover.star-rating click.star-rating','.star-btn', function(e)
			{
				_this.setStarRatingArgs(this);
				_this.handleEvents(e);
			});
			// Visualization
			$('body').on('mouseout.star-rating','.star-rating', function(e)
			{
				_this.setStarRatingArgs(this);
				_this.handleEvents(e);
			});
		},


		/**
		 * Set rating properties
		 * Manage events associated with the evaluation of the material
		 */
		setStarRatingArgs: function(element)
		{
			this.ratingId = $(element).closest('div.rating-wrapper').attr('id');
			this.mode =  $(element).closest('div.rating-wrapper').data('mode');
			this.rating = Math.round($('div#' + this.ratingId).children('span.rating-info').children('span.average-rating').html());
			/* Handling star events */
			if( $(element).attr('class') !== 'star-rating') 
			{
				this.element = element;
				this.starId = $(element).attr('class').split(' ')[1];
				this.starNum = this.starId.replace('star-', '');
				this.wpId = $(element).closest('div.rating-wrapper').data('id');
				this.votes = $('div#' + this.ratingId).children('span.rating-info').children('span.total-votes').html();
			}
		},


		/**
		 * Implement the 'EventListener' interface
		 */
		handleEvents: function(event)
		{
			if( event.type === 'click' )
			{
				this.ratingSave();
			}
			if( event.type === 'mouseover' )
			{
				this.ratingChange(this.starNum);
			}
			if( event.type === 'mouseout' && (event.toElement.className !== 'star-rating' || event.fromElement.className === 'star-rating') )
			{
				this.ratingChange(this.rating);
			}
		},


		/**
		 * Hovering over the rating
		 */
		ratingChange: function(pointer)
		{
			pointer = parseInt(pointer);

			for( var i = 1; i <= pointer; i++ )
			{
				if( $('div#' + this.ratingId).children('.star-rating').children('.star-' + [i]).children('.fa').hasClass('fa-star-o') )
				{
					$('div#' + this.ratingId).children('.star-rating').children('.star-' + [i]).children('.fa').removeClass('fa-star-o');
					$('div#' + this.ratingId).children('.star-rating').children('.star-' + [i]).children('.fa').addClass('fa-star');
				}
			}
			for( var i = pointer+1; i <= 5; i++ )
			{
				if( $('div#' + this.ratingId).children('.star-rating').children('.star-' + [i]).children('.fa').hasClass('fa-star') )
				{
					$('div#' + this.ratingId).children('.star-rating').children('.star-' + [i]).children('.fa').removeClass('fa-star');
					$('div#' + this.ratingId).children('.star-rating').children('.star-' + [i]).children('.fa').addClass('fa-star-o');
				}
			}
		},


		/**
		 * Saving rating
		 */
		ratingSave: function()
		{
			// Data cunstruct
			var data = {};
			data.proof = this.proof.save;
			data.id = this.wpId;
			data.mode = this.mode;
			data.rate = this.starNum;
			// Ajax
			$.ajax({
				url: template_dir+'/ajax/star_rating.php',
				type: 'POST',
				dataType: 'json',
				data: data,
				success: this.saveSuccess.bind(this),
				error: function(response, code)
				{
					console.log(response);
				}
			});
		},


		/**
		 * Saving rating
		 */
		saveSuccess: function(response, code, xml)
		{
			if( response['result'] )
			{
				// Full-time application work
				$('#' + this.ratingId).children('span.rating-info').children('span.average-rating').text(response['result']['total']);
				$('#' + this.ratingId).children('span.rating-info').children('span.total-votes').text(response['result']['votes']);
			}
			else
			{
				// Log
				//console.log(response['log']);
			}
			// Server answer
			console.log(response['answer']);
		},


	};

})(jQuery);

$(document).ready(function() {
	$.runStarRating.initRating();
});