/**
 * HighSlide presets
 * 
 *
 * @author veselka.ua
 * @version 0.2
 * @modify 14-06-2016
 */


hs.graphicsDir = template_dir + "/assets/img/graphics/";

hs.showCredits = false;
hs.outlineType = 'drop-shadow';
hs.transitions = ['expand', 'crossfade'];
hs.dimmingOpacity = 0.75;
hs.fadeInOut = true;
hs.align = 'center';
hs.marginTop = 60;
hs.marginBottom = 60;
hs.allowMultipleInstances = false;
hs.blockRightClick = true;
hs.captionEval = 'this.thumb.alt';
hs.captionOverlay.position = 'bottom center';


// Add the slideshow controller
hs.addSlideshow({
	interval: 5000,
	repeat: false,
	useControls: false,
	fixedControls: false,
	overlayOptions: {
		className: 'large-dark',
		opacity: 0.6,
		position: 'bottom center',
		offsetX: 0,
		offsetY: -15,
		hideOnMouseOut: true
	},
	thumbstrip: {
		mode: 'horizontal',
		position: 'bottom center',
		relativeTo: 'viewport'
	}

});

hs.lang = {
	cssDirection: 'ltr',
	loadingText: 'Загрузка...',
	loadingTitle: 'Отмена',
	focusTitle: 'click to bring to front',
	fullExpandTitle: 'Растянуть до оригинального размера',
	creditsText: 'powered by Highslide JS',
	creditsTitle: 'visit Highslide JS website',
	previousText: 'Предыдущая',
	nextText: 'Следующая',
	moveText: 'Передвинуть',
	closeText: 'Закрыть',
	closeTitle: 'Закрыть (ESC)',
	resizeTitle: 'Изменить размер',
	playText: 'Слайдшоу',
	playTitle: 'Запустить слайдшоу (SPACEBAR)',
	pauseText: 'Пауза',
	pauseTitle: 'Остановить слайдшоу (SPACEBAR)',
	previousTitle: 'Предыдущая (ARROW LEFT)',
	nextTitle: 'Следующая (ARROW RIGHT)',
	moveTitle: 'Передвинуть',
	fullExpandText: 'На весь экран',
	number: 'Изображение %1 of %2',
	restoreTitle: 'Клик для закрытия, Используйте стрелки, чтобы листать изображения'
};



jQuery(document).ready(function() {
	
	// attach highslide-CSS-class to linked images in a post
	jQuery("a[href$='jpg'] img, a[href$='JPG'] img, a[href$='jpeg'] img, a[href$='JPEG'] img, a[href$='png'] img, a[href$='PNG'] img, a[href$='gif'] img, a[href$='GIF'] img").parent().addClass("highslide");

	// uncomment block below, to group images in slideshougroups (CSS-class "post" required in template)
	//jQuery(".post").each(function(index) {		
	//	jQuery(this).find("a.highslide").each(function() {
	//		this.onclick = function() {
	//			return hs.expand(this, { slideshowGroup: index });
	//		}
	//	});
	//});
	
	// add comment slahes to the block below, to group images in slideshougroups
	
	$("a.highslide").each(function() {
		this.onclick = function() {
			$data = $(this).data('gallery-group');
			if( $data != 'undefined') {
				return hs.expand(this,{ slideshowGroup: $data });
			}
			return hs.expand(this);
		}
	});

});