/**
 * Help buttons
 * 
 * Bootstrap depended
 *
 * @author veselka.ua
 * @version 0.2
 * @modify 25-02-2018
 */

var helpButtonsEvents = (function ($)
{
	$.helpButtons = {


		/**
		 * Popover
		 */
		popover: {
			btnId:			'#help-search-form',
			selectorName:	'search-popover',
			container:		'#help-buttons',
		},
		popoverSearch: {
			btnId:			'#navbar-search-form',
			selectorName:	'search-popover',
			container:		'#masthead-shopping',
		},


		/**
		 * Anchors
		 */
		anchor: {
			selector:		'.scroll-section',
			next:			false,
		},


		/**
		 * Social networks
		 */
		social: {
			method:			'feed',
			name:			'',
			url:			'',
			image:			'',
			description:	'',
		},


		/**
		 * Init
		 */
		init: function ()
		{
			var _this = this;

			$( window ).load( function(){

				// Behavior listeners
				_this.bahaviorActions();

				// Current visible section
				_this.setCurrentSection();

				// Scroll actions. Btn show/hide
				_this.scrollActions();

				// Search
				_this.popoverSearchActions();

				// Social data collect
				_this.socialNetworksData();

				// Share buttons popups defaults
				_this.sharePopupsActions();
			});
		},


		/**
		 * Behavior listeners
		 */
		bahaviorActions: function()
		{
			var _this = this;

			// Scrollup
			$( '#scrollup, .scrollup' ).on( 'click', function() {
				$('html, body').animate({
					scrollTop:0
				}, 800);
				return false;
			});

			// Scrolldown
			$('#scrolldown, .scrolldown').on( 'click', function(e) {

				if( _this.anchor.next )
				{
					$('html, body').animate({
						scrollTop: $(_this.anchor.next).offset().top
					}, 800);
				} else {
					$('html, body').animate({ scrollTop: $(document).scrollTop() + $(window).height() }, 800 );
				}
				return false;
			});

			// Share buttons
			$( '#share' ).on( 'click', function()
			{
				$('.share-btn').removeClass('hide-btn');
				$('#share').addClass('hide-btn');
			});
			$( '#hide-social' ).on( 'click', function()
			{
				$('.share-btn').addClass('hide-btn');
				$('#share').removeClass('hide-btn');
			});

			// Binotel
			$( '.bingc-action-open-passive-form' ).on( 'click', function() {
				window.BinotelGetCall.openPassiveForm();
			});
		},


		/**
		 * Current section
		 */
		setCurrentSection: function () {
			var _this = this;
			// Scrolled area height
			this.anchor.cutoff = $(window).scrollTop();
			this.anchor.next = false;
			// Toggle current
			$(this.anchor.selector).each(function()
			{
				if( $(this).offset().top > _this.anchor.cutoff ) {
					_this.anchor.next = $(this);
					return false; // stops the iteration after the first one on screen
				}
			});
		},


		/**
		 * Scroll actions
		 */
		scrollActions: function()
		{
			var _this = this;
			// Scroll
			$(window).scroll( function()
			{
				// Hide popover on scroll
				//$('#search').popover('hide');
				// Current visible section
				_this.setCurrentSection();
				// Btn
				setTimeout(function()
				{
					if( $(document).scrollTop() > 0 )
					{
						if( $('#scrollup').css('display') != 'block' )
						{
							$('#scrollup').fadeIn('fast').css('display', 'block');
						}
					}
					else
					{
						if( $('#scrollup').css('display') == 'block' )
						{
							$('#scrollup').hide();
						}
					}

					if( $(document).scrollTop() + $(window).height() == $(document).height() )
					{
						if( $('#scrolldown').css('display') == 'block' )
						{
							$('#scrolldown').hide();
						}
					}
					else
					{
						if( $('#scrolldown').css('display') != 'block' )
						{
							$('#scrolldown').fadeIn('fast').css('display', 'block');
						}
					}
				}, 800);
			});

			// Btn show
			if( $(document).scrollTop() + $(window).height() < $(document).height() )
			{
				$('#scrolldown').fadeIn('fast').css('display', 'block');
			}
			if( $(document).scrollTop() > 0 )
			{
				$('#scrollup').fadeIn('fast').css('display', 'block');
			}
		},


		/**
		 * Search popover
		 */
		popoverSearchActions: function()
		{
			var _this = this;
			// Show popover in Help Buttons
			$(this.popover.btnId).popover({
				animation:false,
				container: this.popover.container,
				placement:'left',
				html:true,
				template:'<div id="'+this.popover.selectorName+'" class="popover" role="tooltip" style=""><div class="arrow"></div><div class="popover-content"></div></div>',
				content: ''
			});
			// Size of help buttons popover
			$(this.popover.btnId).on('shown.bs.popover', function()
			{
				var left = 246;
				var right = 48;
				if( window.innerWidth > 768 )
				{
					left = 280;
					right = 50;
				}
				$('#'+$(this).attr('aria-describedby')).css('left','-'+left+'px');
				$('#'+$(this).attr('aria-describedby')).css('right',right+'px');
			});

			// Show popover in Navbar
			$(this.popoverSearch.btnId).popover({
				animation:false,
				container: this.popoverSearch.container,
				placement:'bottom',
				html:true,
				template:'<div id="'+this.popoverSearch.selectorName+'" class="popover" role="tooltip" style=""><div class="arrow"></div><div class="popover-content"></div></div>',
			});
			// Size of help Navbar popover
			$(this.popoverSearch.btnId).on('shown.bs.popover', function()
			{
				$('#'+$(this).attr('aria-describedby')).css('max-width','100%');
				$('#'+$(this).attr('aria-describedby')).css('top','62px');
				$('#'+$(this).attr('aria-describedby')).css('left','15px');
				$('#'+$(this).attr('aria-describedby')).css('right','15px');
				$('#'+$(this).attr('aria-describedby')+' .arrow').css('left','25px');
			});

			// Hide on click outside, trigger='focus' not working
			$('body').on('click', function (e)
			{
				//did not click a popover toggle, or icon in popover toggle, or popover
				if( $(e.target).data('toggle') !== 'popover'
					&& $(e.target).parents('[data-toggle="popover"]').length === 0
					&& $(e.target).parents('.popover.in').length === 0 )
				{
					$(_this.popover.btnId).popover('hide');
				}
			});
			// BUGFIX: double click
			$('body').on('hidden.bs.popover', function(e)
			{
				$(e.target).data('bs.popover').inState.click = false;
			});
		},


		/**
		 * Collect Open Graph data
		 */
		socialNetworksData: function()
		{
			var _this = this;
			var prop;
			$.each(this.social, function(key, val)
			{
				_this.social[key] = $('meta[property="og:'+key+'"]').attr('content');
			});
			//console.log(this.social);
		},


		/**
		 * Share buttons actions
		 */
		sharePopupsActions: function()
		{
			var _this = this;
			var url;
			// Facebook
			$('#share-fb').click(function()
			{
				/*postToFeed(_this.social);
				return true;*/
				url  = 'http://www.facebook.com/sharer.php?';
				url += 'p[title]='     + encodeURIComponent(_this.social.title);
				url += '&p[summary]='   + encodeURIComponent(_this.social.description);
				url += '&p[url]='       + encodeURIComponent(_this.social.url);
				url += '&p[images][0]=' + encodeURIComponent(_this.social.image);
				_this.popupView(url);
			});
			$('#share-vk').click(function()
			{
				url  = 'http://vkontakte.ru/share.php?';
				url += 'url='          + encodeURIComponent(_this.social.url);
				url += '&title='       + encodeURIComponent(_this.social.title);
				url += '&description=' + encodeURIComponent(_this.social.description);
				url += '&image='       + encodeURIComponent(_this.social.image);
				url += '&noparse=true';
				_this.popupView(url);
			});
			$('#share-pi').click(function()
			{
				url  = 'http://pinterest.com/pin/create/link/?';
				url += 'url='          + encodeURIComponent(_this.social.url);
				url += '&description='       + encodeURIComponent(_this.social.title);
				url += '&media='       + encodeURIComponent(_this.social.image);
				_this.popupView(url);
			});
			$('#share-gp').click(function()
			{
				url  = 'https://plus.google.com/share?';
				url += 'url=' + encodeURIComponent(_this.social.url);
				_this.popupView(url);
			});
			$('#share-ok').click(function()
			{
				url  = 'http://www.odnoklassniki.ru/dk?st.cmd=addShare&st.s=1';
				url += '&st.comments=' + encodeURIComponent(_this.social.description);
				url += '&st._surl='    + encodeURIComponent(_this.social.url);
				_this.popupView(url);
			});
			$('#share-tw').click(function()
			{
				url  = 'http://twitter.com/share?';
				url += 'text='      + encodeURIComponent(_this.social.title);
				url += '&url='      + encodeURIComponent(_this.social.url);
				url += '&counturl=' + encodeURIComponent(_this.social.url);
				_this.popupView(url);
			});
		},


		/**
		 * Popup action
		 */
		popupView: function(url) {
			window.open(url,'','tomenubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');
		},


	}

})(jQuery);

$(document).ready(function()
{
	if( $('#help-buttons').length || $('#btn-scrollup').length || $('#btn-scrollbown').length )
	{
		$.helpButtons.init();
	}
});