<?php
/**
 * Шаблон для отображения архивов.
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

get_header();
?>

		<section id="content" class="col-md-8" itemscope itemtype="http://schema.org/Blog">
			<meta itemprop="description" content="<?php bloginfo('description'); ?>" />
		<?php do_action( 'content_before' ); ?>

			<h1 class="archive-title" itemprop="name"><?php do_action('h1_title'); ?></h1>
			<?php
			// Поиск изображения для категории
			//get_template_part( 'view/cat-img-inject' );

			if ( have_posts() ) {
				// Цикл Вордпресс
				while ( have_posts() ) : the_post();
					// По умолчанию загрузится post.php если не существует post-<post_format>.php
					get_template_part( 'view/post', get_post_format() );
				endwhile;
		
			} else {
				get_template_part('view/post/noresults');
			} // endif
			
			// Навигация в архиве
			do_action( 'page_navigation' );

			// Вывод описания категории
			$cat_desc = term_description();
			if( $cat_desc && $cat_desc != '' ) {
			?>

			<div itemprop="description" class="category-description col-xs-12">
				<?php echo $cat_desc; ?>
			</div>
			<?php
			}
		
			do_action( 'content_after' );
			?>
		</section><!-- #content -->
<?php

	get_sidebar();
	get_footer();
?>
