<?php
/**
 * Запись данных формы в таблицу.
 * 
 * Серверная часть, принимает json данные из модального окна и сохранаяет в GDrive.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

/**
 * Проверка легитимности запуска скрипта.
 */
require_once '__check.php';

/**
 * Не хешированные ключи JS.
 */
require_once '__proof.php';


/**
 * Сохранение данных.
 */
if( $_POST['proof'] == md5($proof['data_save']) ) {
	try{

		// Проверка наличия данных формы (в данном случае только имени формы)
		if( !isset($_POST['form_name']) ) {
			throw new Exception('No form data!');
		}

		/**
		 * Инициализация Вордпресс.
		 */
		require_once '__wp.php';

		/**
		 * Google API.
		 */
		require_once '../../../../' . 'vendor/autoload.php';
		// Экземпляр объекта с инструментами для работы с Google Drive
		$gdrive_tools = new GdriveTools();

		/**
		 * Экземпляр объекта для работы с формами.
		 */
		$forms_data = new FormsData();
		$forms_data->get_load();

		/**
		 * Файлы с классами товаров.
		 */
		if( isset($_SESSION['gdrive']) ) {
			// Общий класс товаров
			require_once SHOP_PATH . '/lib/product/data.class.php';
			$product_data = new ProductData();
		} else {
			$product_data = false;
		}

		/**
		 * кземпляр объекта экспорта
		 */
		// В качестве аргумента принимает экземпляр объекта работы с Google API и экземпляр объекта обрабатывающий POST данные
		$export = new GdriveExportForm( $gdrive_tools, $forms_data, $product_data );
		$export->save_form_data();

		// Удаление переменной Gdrive из сессии данные корзины или быстрого заказа записаны если таковые были переданы
		unset($_SESSION['gdrive']);

		/**
		 * Результат работы в JS.
		 */
		echo json_encode($proof['data_answer']);

	}
	catch(Exception $e) {
		echo json_encode($e->getMessage());
	}
} else {
	throw new Exception('No data to save!');
}

?>