<?php
/**
 * Слайд прослойка между слайдами в лендинге лендинге.
 * 
 *
 * Параметры дополнительных полей:
 *
 * static_form_header - ID статической контакной формы
 * static_form_content - ID статической контакной формы
 * static_wrap - список селекторов для обертки контактной формы
 * btn_ico - Иконка кнопки (селектор fontawesome)
 * btn_title - Текст кнопки
 * btn_class - Дополнительные селекторы для кнопки
 * btn_form_header - ID контакной формы (модальнае контактная форма) в заголовке слайда
 * btn_link_header - Адрес ссылки для кнопки
 * btn_form_content - ID контакной формы (модальнае контактная форма) в контентной части слайда
 * btn_link_content - Адрес ссылки для кнопки
 * pattern - флаг необходимости замтемнения фонового изображения
 * phones_header - Список телефонов строкой в заголовке
 * phones_content - Список телефонов строкой в контентной части
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/veselka_landing
 */

// Фон
$slide = page_cover($post->ID);
// Затемнение изображения
$pattern =  page_pattern($post->ID);
// Тег заголовка
$h = header_tag($post->ID);
?>

			<div id="<?= $post->post_name; ?>" class="landing-interlayer clearfix<?= $slide['class']; ?>"<?= $slide['bg']; ?>>
				<div class="interlayer-container<?= $pattern; ?>">

					<div class="slide-heading">
						<div class="container">

							<<?= $h ?> class="slide-title"><?= seo_page_title($post->ID); ?></<?= $h ?>>
							<?php
								if( $post->post_excerpt != '' ) {
							?>

							<div class="lead"><?= $post->post_excerpt; ?></div>
							<?php
								} // endif
							?>
						</div><!-- /.container -->
					</div><!-- /.slide-heading -->

					<?php
						if( $post->post_content != '' ) {
					?>
					<div class="interlayer-content">
						<div class="container">
							<div class="lead"><?= $post->post_content; ?></div>
						</div><!-- /.container -->
					</div><!-- /.interlayer-content -->
					<?php
						} // endif
					?>


					<?php
						$btn_header = header_button($post->ID);
						$btn_content = content_button($post->ID);
						$btn = '';
						if( $btn_header != '' ) {
							$btn = $btn_header;
						} elseif( $btn_content != '' ) {
							$btn = $btn_content;
						}
						if( $btn != '' ) {
					?>
					<div class="interlayer-content">
						<div class="container">
							<?= $btn; ?>
						</div><!-- /.container -->
					</div><!-- /.interlayer-content -->
					<?php
						} // endif
					?>


					<?php
						$static_header = static_contact_form_header($post->ID);
						$static_content = static_contact_form_content($post->ID);
						$static = '';

						if( $static_header != '' ) {
							$static = $static_header;
						} elseif( $static_content != '' ) {
							$static = $static_content;
						}
						if( $static != '' ) {
					?>
					<div class="interlayer-content">
						<div class="container">
							<?= $static; ?>
						</div><!-- /.container -->
					</div><!-- /.interlayer-content -->
					<?php
						} // endif
					?>


					<?php
						$phones_header = get_post_meta($post->ID, 'phones_header', true);
						$phones_content = get_post_meta($post->ID, 'phones_content', true);
						if( ( (bool)$phones_header || (bool)$phones_content ) && has_action( 'many_phones_slide' ) ) {
					?>
					<div class="interlayer-content">
						<div class="container">
							<?php do_action( 'many_phones_slide' ); ?>
						</div><!-- /.container -->
					</div><!-- /.interlayer-content -->
					<?php
						} // endif
					?>

				</div><!-- /.interlayer-container -->

			</div><!-- /#landing-interlayer -->