<?php
/**
 * Функции оформления лендинга.
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/veselka_landing
 */

// Загловок из дополнительного поля записи.
function seo_page_title($post_id) {
	$page_title = get_post_meta($post_id, 'h1', true);
	if( !$page_title || $page_title == '' ) {
		$page_title = get_the_title($post_id);
	}
	return $page_title;
}

// Загловок из дополнительного поля записи.
function header_tag($post_id) {
	$header_tag = get_post_meta($post_id, 'heading', true);
	if( !in_array($header_tag,['h1','h2','h3','h4','h5','h6','span','div']) ) {
		$header_tag = '';
	}
	if( !$header_tag || $header_tag == '' ) {
		$header_tag = 'h2';
		$parent_id = wp_get_post_parent_id($post_id);
		if( $parent_id ) {
			$parent_nohead = get_post_meta($parent_id, 'nohead', true);
			$parent_header_tag = get_post_meta($parent_id, 'heading', true);
			// Есть заголовок слайда, заголовок третьего уровня
			if( !(bool)$parent_nohead ) {
				$header_tag = 'h3';
			} elseif( (bool)$parent_header_tag && in_array($parent_header_tag,['h1','h2','h3','h4','h5']) ) {
				$parent_header_tag = str_replace('h','',$parent_header_tag);
				$parent_header_tag = 'h' . (string)((int)$parent_header_tag + 1);
			}
		}
	}
	return $header_tag;
}


// Ковер
function page_cover($post_id, $carousel = false) {
	$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post_id), 'full');
	// Позиция ковра
	$bg_position = get_post_meta($post_id, 'cover', true);
	if( !$bg_position || $bg_position == '' ) {
		$bg_position = 'center center';
	}
	// Сборка
	$slide_class = ' white-slide';
	$slide_bg = '';
	if( $large_image_url ) {
		$slide_bg = ' style="background-image: url(' . $large_image_url[0] . '); background-position:' . $bg_position . ';"';
		$slide_class = ' cover-page';
		// Карусель?
		if(!$carousel) {
			$slide_class .= ' parallax';
		}
	}
	// Запрет полной высоты слайда
	if( $carousel || (bool)get_post_meta( $post_id, 'fullheight', true ) ) {
		$slide_class .= ' full-height';
	}
	return [ 'bg' => $slide_bg, 'class' => $slide_class];
}


// Картинка
function page_img($post_id) {
	// Картинка
	$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post_id), 'full');
	$slide_bg = '';
	if( $large_image_url ) {
		$slide_bg = ' style="background-image: url(' . $large_image_url[0] . '); min-height:' . $large_image_url[2] . 'px;"';
	}
	// Ориентация
	$offset = '';
	$image_orientation = get_post_meta( $post_id, 'image_orientation', true );
	if( $image_orientation == 'left' ) {
		$image_orientation = ' bg-orientation bg-orientation-left';
		$offset = ' col-sm-offset-6';
	} else {
		$image_orientation = ' bg-orientation bg-orientation-right';
	}
	return [ 'bg' => $slide_bg, 'src' => $large_image_url[0], 'class' => $image_orientation, 'offset' => $offset ];
}


// Круглая картинка
function page_circle_img($post_id, $alt='') {
	// Картинка
	$thumbnail_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post_id), 'square');
	//Alt
	if( $alt == '' ) {
		$alt = get_the_title( $post_id ) . ' - ' . get_bloginfo('name');
	}
	// Ориентация
	$img = '<img class="img-circle img-responsive center-block" src="'.$thumbnail_image_url[0].'" alt="'. $alt .'">';
	return $img;
}


// Кнопка в заголовке
function header_button($post_id) {
	// Кнопка
	$btn_link = get_post_meta($post_id, 'btn_link_header', true);
	$btn_form = get_post_meta($post_id, 'btn_form_header', true);
	// Есть что возвращать?
	if( !(bool)$btn_link && !(bool)$btn_form ) {
		return '';
	}
	// Разметка формы
	return page_button($post_id,$btn_link,$btn_form);
}
// Кнопка в контентной части
function content_button($post_id) {
	// Кнопка
	$btn_link = get_post_meta($post_id, 'btn_link_content', true);
	$btn_form = get_post_meta($post_id, 'btn_form_content', true);
	// Есть что возвращать?
	if( !(bool)$btn_link && !(bool)$btn_form ) {
		return '';
	}
	// Разметка формы
	return page_button($post_id,$btn_link,$btn_form);
}
// Кнопка без суффиксов, для нестандарных слайдов
// Без привязки к местоположению (контакты)
function common_button($post_id) {
	// Кнопка
	$btn_link = get_post_meta($post_id, 'btn_link', true);
	$btn_form = get_post_meta($post_id, 'btn_form', true);
	// Есть что возвращать?
	if( !(bool)$btn_link && !(bool)$btn_form ) {
		return '';
	}
	// Разметка формы
	return page_button($post_id,$btn_link,$btn_form);
}
// Кнопка общая функция
function page_button($post_id,$btn_link,$btn_form) {

	//$form_service = get_post_meta($post_id, 'form-service', true);
	$btn_title = get_post_meta($post_id, 'btn_title', true);
	$btn_ico = get_post_meta($post_id, 'btn_ico', true);
	$btn_class = get_post_meta($post_id, 'btn_class', true);
	// Сборка кнопки
	if( !(bool)$btn_class ) {
		$btn_class = 'btn btn-lg btn-info';
	}
	// Форма
	if( $btn_form ) {
		$order_link = '#' . $btn_form;
		$btn_class = 'modal-show ' . $btn_class;
		$data_part = 'data-toggle="modal" data-target="#' . str_replace( '_', '-', $btn_form ) . '-form"';
		/*if( $form_service ) {
			$data_part = $data_part . '  data-service-name="' . $form_service . '"';
		}*/
	} else {
		$data_part = '';
		if( !$btn_link ) {
			$order_link = '#slide-contacts'; // По умолчанию ссылка на слайд контактов
		} else {
			$order_link = $btn_link;
		}
	}
	// Заголовок кнопки
	if( !$btn_title ) {
		$btn_title = __( 'More', 'spiral' );
	}
	// Иконка кнопки
	if( !(bool)$btn_ico ) {
		$btn_ico = '';
	} else {
		$btn_ico = '<i class="fa fa-fw '.$btn_ico.'" aria-hidden="true"></i>&nbsp;';	
	}
	// Результат
	return '<a href="' . $order_link . '" class="' . $btn_class . '" role="button" ' . $data_part . ' title="' . strip_tags($btn_title) . '">' . $btn_ico . $btn_title . '</a>';
}




// Затемнение слайда
function page_pattern($post_id) {

	$pattern = get_post_meta($post_id, 'pattern', true);
	// Есть что возвращать?
	if( !(bool)$pattern ) {
		return '';
	}
	return ' patterned';
}

// Статическая контактная форма
function static_contact_form_header($post_id) {
	$form = get_post_meta($post_id, 'static_form_header', true);
	if( !$form || $form == '' ) {
		return '';
	}

	// Разметка статической формы
	return static_contact_form($post_id,$form);
}
function static_contact_form_content($post_id) {
	$form = get_post_meta($post_id, 'static_form_content', true);
	if( !$form || $form == '' ) {
		return '';
	}
	// Разметка статической формы
	return static_contact_form($post_id,$form);
}
function static_contact_form($post_id,$form) {
	// Существует хук?
	if( !has_filter( 'return_static_contact_form' ) ) {
		return '';
	}

	$form = apply_filters( 'return_static_contact_form', $form );
	// Обертка формы
	$class = get_post_meta($post_id, 'static_wrap', true);
	if( !$class || $class == '' ) {
		$class = '';
	}
	$form = '<div class="' . $class . '">' . PHP_EOL . $form . PHP_EOL . '</div>' . PHP_EOL;
	// Грид селекторы нужно обернуть в row
	if( strpos($class, 'col-') ) {
		$form = '<div class="row">' . PHP_EOL . $form . PHP_EOL . '</div>' . PHP_EOL;
	}
	// Разметка
	return $form;
}

// Укорачивание текста
function shorten( $string, $wordsreturned ) {
	$retval = $string;
	$array = explode( " ", $string );
	if( count($array) <= $wordsreturned ){
		$retval = $string;
	} else {
		array_splice($array, $wordsreturned);
		$retval = implode( " ", $array );
	}
	return $retval;
}

?>
