<?php
/**
 * Шаблон маркетинговых инструментов.
 * Инструменты в контентной части слайда после контента дочерних страниц.
 *
 * 1. Кнопка вызова модальной формы или кнопка ссылка.
 * 2. Статическая форма.
 * 3. Телефоны строкой.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/veselka_landing
 */


	// Кнопка вызова модальной формы или кнопка-ссылка
	// Функция определена в _slide_functions.php
	$btn_content = content_button($post_id);
	if( $btn_content != '' ) {
?>
							<span class="col-sm-12 slide-bottom-block text-center">
								<?php echo $btn_content; ?>
							</span>
<?php
	} // endif


	// Телефоны в контентной части слайда
	// Перед подвалом
	$phones_content = get_post_meta($post_id, 'phones_content', true);
	if( (bool)$phones_content && has_action( 'many_phones_slide' ) ) {
?>
							<span class="col-sm-12 slide-bottom-block text-center">
								<?php do_action( 'many_phones_slide' ); ?>
							</span>
<?php
	} // endif


	// Статическая форма в контентной части слайда
	// Перед подвалом
	$static_form_content = static_contact_form_content($post_id);
	if( $static_form_content != '' ) {
?>
							<span class="col-sm-12 slide-bottom-block text-center">
								<?php echo $static_form_content; ?>
							</span>
<?php
	} // endif
?>