<?php
/**
 * Слайд "Услуги" в лендинге
 * 
 */
$term = get_term_by('slug', 'services', 'category');
$meta = get_option( "taxonomy_{$term->term_id}" );
$slide_bg = '';
$slide_class = ' white-slide';
if( isset($meta['cat_thumb']) && $meta['cat_thumb'] != '' )  {
	$slide_bg = 'style="background-image: url(' . $meta['cat_thumb'] . ');" ';
	$slide_class = ' cover-page';
}

$remarka = '';
if( isset($meta['cat_rem']) && $meta['cat_rem'] != '' ) {
	$remarka = '<span>' . $meta['cat_rem'] . '</span>';
}

?>
			<div id="slide-services" class="landing-slide slave-slide<?php echo $slide_class; ?>" <?php echo $slide_bg; ?>>
				<div class="slide-heading">
					<div class="container">
						<h2><?php echo $term->name; ?></h2>
						<?php echo $remarka; ?>
					</div><!-- /.container -->
				</div>
				<div class="container">
					<div class="row">
<?php
	$args = array('post_type' => 'post', 'cat' => $term->term_id );
	$new_query = new WP_Query( $args );
	if( $new_query->have_posts() ) {
		// Цикл Вордпресс
		while( $new_query->have_posts() ) : $new_query->the_post();
			$gliphicon = get_post_meta($new_query->post->ID, 'glyphicon', true);
			if( !$gliphicon || $gliphicon == '' ) {
				$gliphicon = 'glyphicon-file';
			}
?>

						<div id="<?php echo $new_query->post->post_name; ?>" class="col-sm-6 col-md-4 slide-info-block">
							<div class="media togle-text">
								<div class="media-left">
									<a href="#" class="modal-show service-icon" data-target="#modal-service-order-form" role="button" data-toggle="modal" data-service-name="<?php echo $new_query->post->post_name; ?>" title="Заказать <?php the_title(); ?>">
										<span class="glyphicon <?php echo $gliphicon; ?>"></span>
									</a>
								</div>
								<div class="media-body">
									<a href="#" class="modal-show" data-target="#modal-service-order-form" role="button" data-toggle="modal" data-service-name="<?php echo $new_query->post->post_name; ?>" title="Заказать <?php the_title(); ?>">
										<h3><?php the_title(); ?></h3>
									</a>
									<div class="slide-hidden-text">
										<?php the_content(); ?>
									</div>
								</div>
								<input type="button" class="modal-show btn btn-sm btn-danger pull-right" data-target="#modal-service-order-form" data-toggle="modal" data-service-name="<?php echo $new_query->post->post_name; ?>" value="Заказать <?php the_title(); ?>">
							</div>
						</div><!-- /.slide-info-block -->
<?php
		endwhile;
	} // endif
	wp_reset_postdata();
?>
					</div><!-- /.row -->
				</div><!-- /.container -->
			</div><!-- /#slide-services -->