<?php
/**
 * Слайд "Портфолио" в лендинге
 * 
 */
$term = get_term_by('slug', 'portfolio', 'category');
$meta = get_option( "taxonomy_{$term->term_id}" );
$slide_bg = '';
$slide_class = ' white-slide';
if( isset($meta['cat_thumb']) && $meta['cat_thumb'] != '' )  {
	$slide_bg = 'style="background-image: url(' . $meta['cat_thumb'] . ');" ';
	$slide_class = ' cover-page';
}

$remarka = '';
if( isset($meta['cat_rem']) && $meta['cat_rem'] != '' ) {
	$remarka = '<span>' . $meta['cat_rem'] . '</span>';
}
?>
			<div id="slide-portfolio" class="landing-slide slave-slide<?php echo $slide_class; ?>" <?php echo $slide_bg; ?>>
				<div class="slide-heading">
					<div class="container">
						<h2><?php echo $term->name; ?></h2>
						<?php echo $remarka; ?>
					</div><!-- /.container -->
				</div>
				<div class="container responsive-carousel">
					<div id="portfolio-carousel" class="owl-carousel multi-item">
<?php
	$args = array('post_type' => 'post', 'cat' => $term->term_id );
	$new_query = new WP_Query( $args );
	if ( $new_query->have_posts() ) {
		// Цикл Вордпресс
		while ( $new_query->have_posts() ) : $new_query->the_post();
?>
						<div class="portfolio-card">
							<a class="thumbnail" itemprop="thumbnailUrl" href="<?php echo get_permalink(); ?>" class="single-thumbnail" title="<?php the_title_attribute(); ?>" >
							<?php the_post_thumbnail('medium', array('alt' => the_title('', false, '') )); ?>
							</a>
							<a class="" itemprop="thumbnailUrl" href="<?php echo get_permalink(); ?>" class="single-thumbnail" title="<?php the_title_attribute(); ?>" >
								<h3><?php the_title(); ?></h3>
							</a>

						</div>
<?php
		endwhile;
	} // endif
	wp_reset_postdata();
?>

					</div><!-- /#portfolio-carousel -->
				</div><!-- /.container -->
			</div><!-- /#slide-portfolio -->
			
			<div class="slide-footer slide-footer-portfolio">
				<div class="container">
					<div class="term-description">
						<?php echo $term->description; ?>
					</div>
				</div><!-- /.container -->
			</div><!-- /.slide-footer -->