<?php
/*
 * Plugin Name: Veselka Landing
 * Plugin URI: http://veselka.ua
 * Description: Landing Page Constructor. Adds a custom type posts, display patterns of these posts.
 * Version: 2.28
 * Author: Gryaznov Vlad
 * Author URI: http://veselka.ua
 * Text Domain: landing
 * Domain Path: /lang
 * License: GPL2
 *
 * @package veselka_ua/veselka_landing
 */


/*  Copyright 2017 Gryaznov Vlad (email : info@veselka.ua)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
 * Путь к плагину.
 */
if( !defined( 'LANDING_PATH' ) ) {
	define( 'LANDING_PATH', dirname( __FILE__ ) );
}
/**
 * Имя файла плагина для активационного хука.
 */
if( !defined( 'LANDING_PLUGIN_FILE' ) ) {
	define( 'LANDING_PLUGIN_FILE', __FILE__ );
}
/**
 * Путь к шаблону в виде ссылки.
 */
if( !defined( 'LANDING_DIR_URL' ) ) {
	define( 'LANDING_DIR_URL', preg_replace( '#/$#', '', plugin_dir_url( __FILE__ ) ) );
}
/**
 * Имя каталога плагина.
 */
if( !defined( 'LANDING_DIR_NAME' ) ) {
	define( 'LANDING_DIR_NAME', dirname( plugin_basename( __FILE__ ) ) );
}

/**
 * Механизмы плагина - аналог functions.php шаблона
 */
include_once( LANDING_PATH . '/inc/functions.php' );

?>