<?php
/**
 * Лендинг.
 *
 * Подключение дополнительных типов страниц.
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/veselka_landing
 */

class LandingRegistration {


	public function __construct() {
		// Новая таксономия: Категория лендинга
		add_action( 'init', [$this, 'create_taxonomy'], 10, 0 );
		// Новый тип страниц: Элементы лендинга
		add_action( 'init', [$this, 'create_pagetype'] );
	}


	/**
	 * Новая тексономмя: "Категории лендинга".
	 * 
	 * Метод для использования в крючке.
	 */
	final public function create_taxonomy() {
		// Добавление новой таксономмм, не иерархической как теги
		$labels = [
			'name'							=>	__( 'Landing blocks', 'landing' ),
			'singular_name'					=>	__( 'Landing block', 'landing' ),
			'menu_name'						=>	__( 'Landing blocks', 'landing' ),
			'search_items'					=>	__( 'Search Landing blocks', 'landing' ),
			'popular_items'					=>	__( 'Popular Landing blocks', 'landing' ),
			'all_items'						=>	__( 'All Landing blocks', 'landing' ),
			'parent_item'					=>	null,
			'parent_item_colon'				=>	null,
			'edit_item'						=>	__( 'Edit Landing block', 'landing' ),
			'update_item'					=>	__( 'Update Landing block', 'landing' ),
			'add_new_item'					=>	__( 'Add New Landing block', 'landing' ),
			'view_item'						=>	__( 'View Landing block', 'landing' ),
			'new_item_name'					=>	__( 'New Landing block Name', 'landing' ),
			'separate_items_with_commas'	=>	__( 'Separate Landing blocks with commas', 'landing' ),
			'choose_from_most_used'			=>	__( 'Choose from the most used Landing blocks', 'landing' ),
			'add_or_remove_items'			=>	__( 'Add or remove Landing blocks', 'landing' ),
			'not_found'						=>	__( 'No Landing blocks found', 'landing' ),
		];

		$args = [
			'labels'				=>	$labels,
			'show_ui'				=>	true,
			'show_admin_column'		=>	true,
			'show_in_nav_menus'		=>	false,
			'hierarchical'			=>	false,
			'update_count_callback'	=>	'_update_post_term_count',
			'query_var'				=>	true,
			'rewrite'				=>	[ 'slug' =>	'landing' ],
			'publicly_queryable'	=>	false,
			'show_admin_column'		=>	true,
			//'meta_box_cb'			=>	'post_categories_meta_box',
		];

		register_taxonomy( 'landing', [ 'landing-elements' ], $args );
	}




	/**
	 * Создание нового типа страницы.
	 * 
	 * Метод для использования в крючке.
	 *
	 * @param void
	 * @return void
	 */
	final public function create_pagetype() {

		$labels = [
			// Переопределяет название в меню (элемент 'label' в массиве параметров $args), а также этот текст используется на странице управления таксономиями для этого типа постов (если таксономия будет добавлена)
			'name'					=>	__( 'Landing Elements', 'landing' ),
			// Название одного экземпляра этого поста
			'singular_name'			=>	__( 'Landing Element', 'landing' ),
			// Название меню для добавления нового поста данного типа
			'add_new'				=>	__( 'Add new', 'landing' ),
			// Заголовок страницы, на которой добавляются новые посты
			'add_new_item'			=>	__( 'Add new landing element', 'landing' ),
			// Заголовок страницы, на которой посты редактируются
			'edit_item'				=>	__( 'Edit landing element', 'landing' ),
			// По умолчанию: "Новый пост"/"Новая страница"
			'new_item'				=>	__( 'New landing element', 'landing' ),
			// При редактировании записи вверху есть кнопка, позволяющая посмотреть её на сайте. Это текст кнопки
			'view_item'				=>	__( 'View landing element', 'landing' ),
			// Текст кнопки на странице просмотра записей, расположенной вверху справа. Обычно там текст "Поиск записей"
			'search_items'			=>	__( 'Search landing elements', 'landing' ),
			// Текст на странице с постами, когда не найдено ни одного поста
			'not_found'				=>	__( 'No landing elements found', 'landing' ),
			// Текст в корзине в случае, если не найдено ни одного поста
			'not_found_in_trash'	=>	__( 'No landing elements found in trash', 'landing' ),
			// Для родительских типов. для древовидных типов
			'parent_item_colon'		=>	__( 'Parent landing element', 'landing' ),
			// Название меню
			'menu_name'				=>	__( 'Landing', 'landing' ),
		];

		$args = [
				'labels'				=>	$labels,
				'public'				=>	true,
				'publicly_queryable'	=>	true,
				'show_ui'				=>	true,
				'query_var'				=>	true,
				'menu_icon'				=>	'dashicons-media-document',
				'capability_type'		=>	'post',
				'exclude_from_search'	=>	true,
				'menu_position'			=>	21,
				'has_archive'			=>	false,
				'rewrite'				=>	[
												'slug'			=> '/landing-elements',
												'with_front'	=> true
				],
				'hierarchical'			=>	true,
				'supports'				=>	[
												'title',
												'editor',
												'thumbnail',
												'excerpt',
												'custom-fields',
												'revisions',
												'page-attributes',
				],
				'taxonomies'			=>	['landing'],
				'show_in_nav_menus'		=>	false,
		];

		register_post_type( 'landing-elements', $args );
		flush_rewrite_rules(false);
	}



} // end LandingRegistration
?>