<?php
/**
 * Лендинг.
 *
 * Подключение библиотек.
 * Обработка параметров.
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/veselka_landing
 */

class LandingElements {

	/**
	 * Объект загрузки и отображения бибилиотек.
	 * @type object
	 */
	private $lib_construct;

	public function __construct() {
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'landing_lib_exchange', [$this, 'get_lib_exchange'], 10, 1 );
	}


	/**
	 * Инициализация библиотек.
	 *
	 * @param object $lib_construct
	 * @return void
	 */
	final public function get_lib_exchange( $lib_construct ){

		// Объект с общими методами в локальное свойство
		$this->lib_construct = $lib_construct;

		// Загрузка библиотек
		$this->set_libs(['landing','counter']);
	}


	/**
	 * Передача списка библиотек в общий метод.
	 *
	 * @param array $args
	 * @return void
	 */
	private function set_libs($args) {
		// Список библиотек
		$libs = ['css','js'];
		// Формирование путей к библиотекам
		foreach( $libs as $lib ) {
			foreach( $args as $lib_name ) {
				if( is_file( LANDING_PATH . '/assets/' . $lib . '/' . $lib_name . '.min.' . $lib ) ) {
					$path = LANDING_DIR_URL . '/assets/' . $lib . '/' . $lib_name . '.min.' . $lib;
				} elseif ( is_file( LANDING_PATH . '/assets/' . $lib . '/' . $lib_name . '.' . $lib ) ) {
					$path = LANDING_DIR_URL . '/assets/' . $lib . '/' . $lib_name . '.' . $lib;
				} else {
					continue;
				}
				// Подключение библиотек
				$this->lib_construct->set_lib_list(
					[
						$lib_name	=>	$path,
					],
					$lib
				);
			}
		}
		// Video
		$this->lib_construct->set_lib_list(
			[
				'video'	=>	'https://cdnjs.cloudflare.com/ajax/libs/jquery.mb.YTPlayer/3.0.20/jquery.mb.YTPlayer.min.js',
			],
			'js',
			[],
			['landing.php']
		);
		// Video
		$this->lib_construct->set_lib_list( ['help_buttons'=>true], 'js', [], ['landing.php'] );
		$this->lib_construct->set_lib_list( ['help_buttons'=>true], 'css', [], ['landing.php'] );
	}


} // end LandingElements
?>